/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.node;

import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.pipeliner.node.NodeShape;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.asm.Type;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Vector;

public class DataNode
extends DeferredNode {
    private Vector vector;

    public DataNode(Vector vector2) {
        this.vector = vector2 instanceof MemoizedComputation ? ((MemoizedComputation)vector2).forceResult() : vector2;
    }

    @Override
    public String getDebugLabel() {
        if (this.vector.length() == 1) {
            if (this.vector.isElementNA(0)) {
                return "NA";
            }
            if (this.vector instanceof IntVector) {
                return this.vector.getElementAsInt(0) + "L";
            }
            if (this.vector instanceof DoubleVector) {
                return Double.toString(this.vector.getElementAsDouble(0));
            }
            if (this.vector instanceof LogicalVector) {
                return this.vector.getElementAsRawLogical(0) == 0 ? "F" : "T";
            }
        }
        return "[" + this.vector.length() + "]";
    }

    @Override
    public Vector getVector() {
        return this.vector;
    }

    @Override
    public NodeShape getShape() {
        return NodeShape.BOX;
    }

    @Override
    public Type getResultVectorType() {
        return Type.getType(this.vector.getClass());
    }

    @Override
    public boolean hasValue(double x) {
        return this.vector.length() == 1 && this.vector.getElementAsDouble(0) == x;
    }

    public boolean equivalent(DeferredNode other) {
        if (!(other instanceof DataNode)) {
            return false;
        }
        DataNode otherData = (DataNode)other;
        Vector.Type vectorType = this.getVector().getVectorType();
        if (!vectorType.equals(otherData.vector.getVectorType())) {
            return false;
        }
        if (this.vector.length() > 10 || this.vector.length() != otherData.vector.length()) {
            return false;
        }
        for (int i = 0; i < this.vector.length(); ++i) {
            if (vectorType.compareElements(this.vector, i, otherData.vector, i) == 0) continue;
            return false;
        }
        return true;
    }
}

