/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.parser.NumericLiterals;
import org.renjin.parser.StringLiterals;
import org.renjin.primitives.text.ReservedWords;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Deparse {
    private static final char BACK_TICK = '`';
    public static int KEEP_INTEGER = 1;
    public static int QUOTE_EXPRESSIONS = 2;
    public static int SHOW_ATTRIBUTES = 4;
    public static int USE_SOURCE = 8;
    public static int WARN_INCOMPLETE = 16;
    public static int DELAY_PROMISES = 32;
    public static int KEEP_NA = 64;
    public static int S_COMPAT = 128;
    public static int HEX_NUMERIC = 256;
    public static int DIGITS_16 = 512;
    public static String[] BINARY_OPS = new String[]{"+", "-", "/", "*", "^", "<-", "<<-", "=", "%in%", "%/%", ":", "==", "!=", "<", ">", "<=", ">=", "&", "&&", "|", "||", "$"};
    public static String[] BINARY_OPS_WITHOUT_SPACE = new String[]{":", "^", "$"};
    public static String[] UNARY_OPS = new String[]{"!", "-", "+"};
    public static String[] CONTROL_STATEMENTS = new String[]{"break", "next"};

    @Internal
    public static String deparse(@Current Context context, SEXP exp2, int widthCutoff, boolean backTick, int options2, int nlines) {
        return new DeparsingVisitor(context, options2, exp2).getResult();
    }

    public static String deparseExp(Context context, SEXP exp2) {
        return new DeparsingVisitor(context, 0, exp2).getResult();
    }

    public static String deparseExpWithAttributes(Context context, SEXP sexp2) {
        return new DeparsingVisitor(context, SHOW_ATTRIBUTES, sexp2).getResult();
    }

    private static String computeNALiteral(Vector x, ElementDeparser deparser) {
        if (Deparse.allNA(x)) {
            return deparser.typedNaLiteral();
        }
        return "NA";
    }

    private static boolean allNA(Vector x) {
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i)) continue;
            return false;
        }
        return true;
    }

    private static enum ElementDeparser {
        LOGICAL{

            @Override
            String deparse(Vector vector2, int index) {
                return vector2.getElementAsRawLogical(index) == 1 ? "TRUE" : "FALSE";
            }

            @Override
            String typedNaLiteral() {
                return "NA";
            }

            @Override
            String deparseEmpty() {
                return "logical(0)";
            }
        }
        ,
        INTEGER{

            @Override
            String deparse(Vector vector2, int index) {
                return vector2.getElementAsInt(index) + "L";
            }

            @Override
            String typedNaLiteral() {
                return "NA_integer_";
            }

            @Override
            String deparseEmpty() {
                return "integer(0)";
            }
        }
        ,
        DOUBLE{

            @Override
            String deparse(Vector vector2, int index) {
                double value = vector2.getElementAsDouble(index);
                if (Double.isNaN(value)) {
                    return "NaN";
                }
                if (Double.isInfinite(value)) {
                    if (value < 0.0) {
                        return "-Inf";
                    }
                    return "Inf";
                }
                return NumericLiterals.toString(value);
            }

            @Override
            String typedNaLiteral() {
                return "NA_real_";
            }

            @Override
            String deparseEmpty() {
                return "numeric(0)";
            }
        }
        ,
        COMPLEX{

            @Override
            String deparse(Vector vector2, int index) {
                Complex complex2 = vector2.getElementAsComplex(index);
                double r = complex2.getReal();
                double i = complex2.getImaginary();
                if (DoubleVector.isFinite(r) && DoubleVector.isFinite(i)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(NumericLiterals.toString(complex2.getReal()));
                    if (complex2.getImaginary() >= 0.0 || Double.isNaN(complex2.getImaginary())) {
                        sb.append("+");
                    }
                    sb.append(NumericLiterals.toString(complex2.getImaginary())).append("i");
                    return sb.toString();
                }
                return String.format("complex(real=%s, i=%s)", NumericLiterals.format(r, "NA"), NumericLiterals.format(i, "NA"));
            }

            @Override
            String typedNaLiteral() {
                return "NA_complex_";
            }

            @Override
            String deparseEmpty() {
                return "complex(0)";
            }
        }
        ,
        STRING{

            @Override
            String deparse(Vector vector2, int index) {
                return "\"" + vector2.getElementAsString(index) + "\"";
            }

            @Override
            String typedNaLiteral() {
                return "NA_character_";
            }

            @Override
            String deparseEmpty() {
                return "character(0)";
            }
        };


        abstract String deparse(Vector var1, int var2);

        abstract String typedNaLiteral();

        abstract String deparseEmpty();
    }

    private static class DeparsingVisitor
    extends SexpVisitor<String> {
        private StringBuilder deparsed = new StringBuilder();
        private Context context;
        private boolean keepAttributes;

        public DeparsingVisitor(Context context, int options2, SEXP exp2) {
            this.context = context;
            this.keepAttributes = (options2 & SHOW_ATTRIBUTES) != 0;
            this.deparse(exp2);
        }

        public void deparse(SEXP exp2) {
            if (this.keepAttributes && this.requiresStructure(exp2)) {
                this.deparsed.append("structure(");
                exp2.accept(this);
                this.deparseAttributes(exp2);
                this.deparsed.append(")");
            } else {
                exp2.accept(this);
            }
        }

        private void deparseAttributes(SEXP exp2) {
            for (Symbol name : exp2.getAttributes().names()) {
                SEXP value = exp2.getAttributes().get(name);
                if (name == Symbols.DIM) {
                    this.appendAttribute(".Dim", value);
                    continue;
                }
                if (name == Symbols.DIMNAMES) {
                    this.appendAttribute(".Dimnames", value);
                    continue;
                }
                if (name == Symbols.NAMES) {
                    this.appendAttribute(".Names", value);
                    continue;
                }
                if (name == Symbol.get("tsp")) {
                    this.appendAttribute(".Tsp", value);
                    continue;
                }
                if (name == Symbols.LEVELS) {
                    this.appendAttribute(".Label", value);
                    continue;
                }
                this.appendAttribute(name.getPrintName(), value);
            }
        }

        private void appendAttribute(String name, SEXP value) {
            this.deparsed.append(", ").append(name).append(" = ");
            this.deparse(value);
        }

        private boolean requiresStructure(SEXP exp2) {
            if (exp2 instanceof FunctionCall || exp2 instanceof S4Object) {
                return false;
            }
            if (exp2 instanceof ExpressionVector) {
                return exp2.getAttributes().hasAnyBesidesName() || this.hasNamesRequiringSpecialHandling(exp2);
            }
            return !exp2.getAttributes().isEmpty();
        }

        private boolean hasNamesRequiringSpecialHandling(SEXP exp2) {
            AttributeMap attributes2 = exp2.getAttributes();
            if (!attributes2.hasNames()) {
                return false;
            }
            StringVector names2 = attributes2.getNames();
            for (int i = 0; i < names2.length(); ++i) {
                if (!names2.isElementNA(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visit(CHARSEXP charExp) {
            StringLiterals.appendEscaped(this.deparsed, charExp.getValue());
        }

        @Override
        public void visit(ComplexVector vector2) {
            this.deparseAtomicVector(vector2, ElementDeparser.COMPLEX);
        }

        @Override
        public void visit(Environment environment2) {
            this.deparsed.append("<environment>");
        }

        @Override
        public void visit(BuiltinFunction builtin) {
            this.visitPrimitive(builtin);
        }

        @Override
        public void visitSpecial(SpecialFunction special) {
            this.visitPrimitive(special);
        }

        private void visitPrimitive(PrimitiveFunction builtin) {
            this.deparsed.append(".Primitive(\"" + builtin.getName() + "\")");
        }

        @Override
        public void visit(IntVector vector2) {
            if (this.isSequence(vector2)) {
                this.deparsed.append(vector2.getElementAsInt(0)).append(":").append(vector2.getElementAsInt(vector2.length() - 1));
            } else {
                this.deparseAtomicVector(vector2, ElementDeparser.INTEGER);
            }
        }

        private boolean isSequence(IntVector vector2) {
            int end;
            if (vector2.length() < 2) {
                return false;
            }
            int start = vector2.getElementAsInt(0);
            int step = start < (end = vector2.getElementAsInt(vector2.length() - 1)) ? 1 : -1;
            int expected = start + step;
            for (int i = 1; i != vector2.length(); ++i) {
                if (vector2.getElementAsInt(i) != expected) {
                    return false;
                }
                expected += step;
            }
            return true;
        }

        @Override
        public void visit(PairList.Node pairList) {
            this.deparseList("pairlist", pairList.namedValues());
        }

        @Override
        public void visit(Null nullExpression) {
            this.deparsed.append("NULL");
        }

        @Override
        public void visit(PrimitiveFunction primitive2) {
            super.visit(primitive2);
        }

        @Override
        public void visit(Promise promise) {
            this.deparse(promise.getExpression());
        }

        @Override
        public void visit(DoubleVector vector2) {
            this.deparseAtomicVector(vector2, ElementDeparser.DOUBLE);
        }

        @Override
        public void visit(StringVector vector2) {
            this.deparseAtomicVector(vector2, ElementDeparser.STRING);
        }

        @Override
        public void visit(LogicalVector vector2) {
            this.deparseAtomicVector(vector2, ElementDeparser.LOGICAL);
        }

        @Override
        public void visit(ListVector list2) {
            this.deparseList("list", list2.namedValues());
        }

        @Override
        public void visit(ExpressionVector vector2) {
            this.deparsed.append("expression(");
            boolean needsComma = false;
            for (NamedValue namedValue : vector2.namedValues()) {
                if (needsComma) {
                    this.deparsed.append(", ");
                } else {
                    needsComma = true;
                }
                this.maybeAppendArgumentName(namedValue, "`NA`");
                DeparsingVisitor elementVisitor = new DeparsingVisitor(this.context, 0, namedValue.getValue());
                this.deparsed.append(elementVisitor.getResult());
            }
            this.deparsed.append(")");
        }

        private void deparseList(String listType, Iterable<NamedValue> list2) {
            this.deparsed.append(listType + "(");
            boolean needsComma = false;
            for (NamedValue namedValue : list2) {
                if (needsComma) {
                    this.deparsed.append(", ");
                } else {
                    needsComma = true;
                }
                this.maybeAppendArgumentName(namedValue, "\"NA\"");
                this.deparse(namedValue.getValue());
            }
            this.deparsed.append(")");
        }

        private void maybeAppendArgumentName(NamedValue namedValue, String naNameLiteral) {
            if (namedValue.hasName()) {
                String name = namedValue.getName();
                if (StringVector.isNA(name)) {
                    this.deparsed.append(naNameLiteral);
                } else {
                    this.deparsed.append(name);
                }
                this.deparsed.append(" = ");
            }
        }

        @Override
        public void visit(FunctionCall call2) {
            if (call2.getFunction() instanceof Symbol) {
                String name = ((Symbol)call2.getFunction()).getPrintName();
                if (name.equals("if")) {
                    this.deparseIf(call2);
                } else if (name.equals("for")) {
                    this.deparseFor(call2);
                } else if (name.equals("while")) {
                    this.deparseWhile(call2);
                } else if (name.equals("repeat")) {
                    this.deparseRepeat(call2);
                } else if (name.equals("{")) {
                    this.deparseBracket(call2);
                } else if (name.equals("(")) {
                    this.deparseParen(call2);
                } else if (this.is(name, CONTROL_STATEMENTS)) {
                    this.deparseControlStatement(name);
                } else if (name.startsWith("%") && name.endsWith("%")) {
                    this.deparseUserInfixOp(name, call2);
                } else if (call2.getArguments().length() == 2 && this.is(name, BINARY_OPS)) {
                    this.deparseBinaryOp(name, call2.getArguments());
                } else if (call2.getArguments().length() == 1 && this.is(name, UNARY_OPS)) {
                    this.deparseUnaryOp(call2);
                } else if (this.isSubset(name)) {
                    this.deparseSubset(name, call2.getArguments());
                } else if (name.equals("~")) {
                    this.deparseTilde(call2);
                } else {
                    this.deparseNormalCall(call2);
                }
            } else {
                this.deparseNormalCall(call2);
            }
        }

        private void deparseUserInfixOp(String name, FunctionCall call2) {
            if (call2.getArguments().length() == 2) {
                this.deparse((SEXP)call2.getArgument(0));
                this.deparsed.append(" ").append(name).append(" ");
                this.deparse((SEXP)call2.getArgument(1));
            } else {
                this.deparsed.append("`").append(name).append("`");
                this.deparsed.append("(");
                this.deparseArgumentList(call2.getArguments().nodes());
                this.deparsed.append(")");
            }
        }

        private void deparseControlStatement(String name) {
            this.deparsed.append(name);
        }

        private void deparseSubset(String name, PairList arguments) {
            this.deparse((SEXP)arguments.getElementAsSEXP(0));
            this.deparsed.append(name);
            this.deparseArgumentList(Iterables.skip(arguments.nodes(), 1));
            this.deparsed.append(this.closingParens(name));
        }

        private void deparseTilde(FunctionCall call2) {
            PairList arguments = call2.getArguments();
            if (arguments.length() == 1) {
                this.deparsed.append("~");
                this.deparse((SEXP)arguments.getElementAsSEXP(0));
            } else if (arguments.length() == 2) {
                this.deparse((SEXP)arguments.getElementAsSEXP(0));
                this.deparsed.append(" ~ ");
                this.deparse((SEXP)arguments.getElementAsSEXP(1));
            } else {
                this.deparseNormalCall(call2);
            }
        }

        private String closingParens(String name) {
            if (name.equals("[")) {
                return "]";
            }
            if (name.equals("[[")) {
                return "]]";
            }
            throw new IllegalArgumentException(name);
        }

        private void deparseUnaryOp(FunctionCall call2) {
            this.deparsed.append(((Symbol)call2.getFunction()).getPrintName());
            this.deparse((SEXP)call2.getArgument(0));
        }

        private void deparseBinaryOp(String name, PairList arguments) {
            this.deparse((SEXP)arguments.getElementAsSEXP(0));
            if (this.is(name, BINARY_OPS_WITHOUT_SPACE)) {
                this.deparsed.append(name);
            } else {
                this.deparsed.append(' ').append(name).append(' ');
            }
            this.deparse((SEXP)arguments.getElementAsSEXP(1));
        }

        private void deparseBracket(FunctionCall call2) {
            this.deparsed.append("{\n");
            for (SEXP statement : call2.getArguments().values()) {
                this.deparse(statement);
                this.deparsed.append("\n");
            }
            this.deparsed.append("}");
        }

        private void deparseParen(FunctionCall call2) {
            this.deparsed.append("(");
            if (call2.getArguments().length() == 0) {
                this.deparsed.append("NULL");
            } else {
                this.deparse((SEXP)call2.getArgument(0));
            }
            this.deparsed.append(")");
        }

        private boolean isSubset(String name) {
            return name.startsWith("[");
        }

        private boolean is(String name, String[] names2) {
            for (String opName : names2) {
                if (!opName.equals(name)) continue;
                return true;
            }
            return false;
        }

        private void deparseNormalCall(FunctionCall call2) {
            if (call2.getFunction() instanceof Function) {
                this.deparsed.append("FUN");
            } else {
                this.deparse(call2.getFunction());
            }
            this.deparsed.append("(");
            this.deparseArgumentList(call2.getArguments().nodes());
            this.deparsed.append(")");
        }

        private void deparseArgumentList(Iterable<PairList.Node> arguments) {
            boolean needsComma = false;
            for (PairList.Node argument : arguments) {
                if (needsComma) {
                    this.deparsed.append(", ");
                } else {
                    needsComma = true;
                }
                if (argument.hasTag()) {
                    argument.getTag().accept(this);
                    this.deparsed.append(" = ");
                }
                this.deparse(argument.getValue());
            }
        }

        private void deparseIf(FunctionCall call2) {
            this.deparsed.append("if (");
            this.deparse((SEXP)call2.getArgument(0));
            this.deparsed.append(") ");
            this.deparse((SEXP)call2.getArgument(1));
            if (call2.getArguments().length() == 3) {
                this.deparsed.append(" else ");
                this.deparse((SEXP)call2.getArgument(2));
            }
        }

        private void deparseRepeat(FunctionCall call2) {
            this.deparsed.append("repeat ");
            this.deparse((SEXP)call2.getArgument(0));
        }

        private void deparseFor(FunctionCall call2) {
            this.deparsed.append("for(");
            this.deparse((SEXP)call2.getArgument(0));
            this.deparsed.append(" in ");
            this.deparse((SEXP)call2.getArgument(1));
            this.deparsed.append(") ");
            this.deparse((SEXP)call2.getArgument(2));
        }

        private void deparseWhile(FunctionCall call2) {
            this.deparsed.append("while (");
            this.deparse((SEXP)call2.getArgument(0));
            this.deparsed.append(") ");
            this.deparse((SEXP)call2.getArgument(1));
        }

        @Override
        public void visit(Symbol symbol2) {
            if (symbol2 != Symbol.MISSING_ARG) {
                String name = symbol2.getPrintName();
                if (Symbols.isValid(name) && !ReservedWords.isReserved(name)) {
                    this.deparsed.append(name);
                } else {
                    this.deparsed.append('`').append(name).append('`');
                }
            } else {
                this.deparsed.append("");
            }
        }

        @Override
        public void visit(S4Object s4Object) {
            this.deparsed.append("<S4 object of class ");
            this.deparse(s4Object.getAttribute(Symbols.CLASS));
            this.deparsed.append(">");
        }

        @Override
        protected void unhandled(SEXP exp2) {
            this.deparsed.append(exp2.toString());
        }

        @Override
        public String getResult() {
            return this.deparsed.toString();
        }

        public <T> void deparseAtomicVector(AtomicVector vector2, ElementDeparser deparser) {
            if (vector2.length() == 0) {
                this.deparsed.append(deparser.deparseEmpty());
            } else if (vector2.length() == 1) {
                if (vector2.isElementNA(0)) {
                    this.deparsed.append(deparser.typedNaLiteral());
                } else {
                    this.deparsed.append(deparser.deparse(vector2, 0));
                }
            } else {
                String naLiteral = Deparse.computeNALiteral(vector2, deparser);
                this.deparsed.append("c(");
                for (int i = 0; i != vector2.length(); ++i) {
                    if (i > 0) {
                        this.deparsed.append(", ");
                    }
                    if (vector2.isElementNA(i)) {
                        this.deparsed.append(naLiteral);
                        continue;
                    }
                    this.deparsed.append(deparser.deparse(vector2, i));
                }
                this.deparsed.append(")");
            }
        }
    }
}

