/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine.view;

import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.primitives.subset.ArraySubsettable;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.MissingSubscript;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class CompositeIntColumnMatrix
extends IntVector
implements DeferredComputation,
ArraySubsettable {
    private int columnLength;
    private int length;
    private final Vector[] columns;

    public CompositeIntColumnMatrix(Vector[] columns, AttributeMap attributeMap) {
        super(attributeMap);
        this.columns = columns;
        this.columnLength = columns[0].length();
        this.length = columns.length * this.columnLength;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int getElementAsInt(int index) {
        int columnIndex = index / this.columnLength;
        int rowIndex = index % this.columnLength;
        return this.columns[columnIndex].getElementAsInt(rowIndex);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new CompositeIntColumnMatrix(this.columns, attributes2);
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public Vector[] getOperands() {
        return this.columns;
    }

    @Override
    public String getComputationName() {
        return "cols";
    }

    @Override
    public Vector subscript(Context context, int[] sourceDim, Subscript[] subscripts) {
        if (sourceDim.length == 2 && sourceDim[1] == this.columns.length && subscripts[0] instanceof MissingSubscript) {
            int columnIndex;
            IndexIterator columnIt = subscripts[1].computeIndexes();
            ArrayList<Vector> selectedColumns = new ArrayList<Vector>();
            while ((columnIndex = columnIt.next()) != -1) {
                selectedColumns.add(this.columns[columnIndex]);
            }
            if (selectedColumns.size() == 0) {
                return IntArrayVector.EMPTY;
            }
            if (selectedColumns.size() == 1) {
                return (Vector)selectedColumns.get(0);
            }
            Vector[] selectedColumnsArray = selectedColumns.toArray(new Vector[selectedColumns.size()]);
            return new CompositeIntColumnMatrix(selectedColumnsArray, AttributeMap.EMPTY);
        }
        return null;
    }

    @Override
    public void copyTo(double[] array2, int offset, int length2) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].copyTo(array2, offset + i * this.columnLength, this.columnLength);
        }
    }
}

