/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DeferredColSums
extends DoubleVector
implements MemoizedComputation {
    private final AtomicVector vector;
    private int numColumns;
    private boolean naRm;
    private double[] sums = null;

    public DeferredColSums(AtomicVector vector2, int numColumns, boolean naRm, AttributeMap attributes2) {
        super(attributes2);
        this.vector = vector2;
        this.numColumns = numColumns;
        this.naRm = naRm;
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector, new IntArrayVector(this.numColumns)};
    }

    @Override
    public String getComputationName() {
        if (this.naRm) {
            return "colSumsNaRm";
        }
        return "colSums";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new DeferredColSums(this.vector, this.numColumns, this.naRm, attributes2);
    }

    @Override
    public double getElementAsDouble(int index) {
        if (this.sums == null) {
            System.err.println("EEK! colSums.computeMeans() called through getElementAsDouble()");
            this.computeMeans();
        }
        return this.sums[index];
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public int length() {
        return this.numColumns;
    }

    private void computeMeans() {
        double[] sums = new double[this.numColumns];
        int sourceIndex = 0;
        double sum2 = 0.0;
        int numRows = this.vector.length() / this.numColumns;
        int colIndex = 0;
        int rowIndex = 0;
        while (colIndex < this.numColumns) {
            double cellValue = this.vector.getElementAsDouble(sourceIndex++);
            if (!this.naRm || !Double.isNaN(cellValue)) {
                sum2 += cellValue;
            }
            if (++rowIndex != numRows) continue;
            rowIndex = 0;
            sums[colIndex] = sum2;
            sum2 = 0.0;
            ++colIndex;
        }
        this.sums = sums;
    }

    @Override
    public boolean isCalculated() {
        return this.sums != null;
    }

    @Override
    public boolean isDeferred() {
        return !this.isCalculated();
    }

    @Override
    public Vector forceResult() {
        if (this.sums == null) {
            this.computeMeans();
        }
        return DoubleArrayVector.unsafe(this.sums, this.getAttributes());
    }

    @Override
    public void setResult(Vector result) {
        this.sums = ((DoubleArrayVector)result).toDoubleArrayUnsafe();
    }
}

