/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.SessionScoped;
import org.renjin.primitives.packaging.BaseNamespace;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceFile;
import org.renjin.primitives.packaging.Package;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.repackaged.guava.collect.HashMultimap;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Multimap;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.io.CharSource;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

@SessionScoped
public class NamespaceRegistry {
    private static final Symbol BASE = Symbol.get("base");
    public static final Set<String> CORE_PACKAGES = Sets.newHashSet("datasets", "graphics", "grDevices", "hamcrest", "methods", "splines", "stats", "stats4", "utils", "grid", "parallel", "tools", "tcltk", "compiler");
    private PackageLoader loader;
    private Multimap<Symbol, Namespace> localNameMap = HashMultimap.create();
    private Map<FqPackageName, Namespace> namespaceMap = Maps.newHashMap();
    private Map<Environment, Namespace> envirMap = Maps.newIdentityHashMap();
    private final Namespace baseNamespace;

    public NamespaceRegistry(PackageLoader loader, Context context, Environment baseNamespaceEnv) {
        this.loader = loader;
        this.baseNamespace = new BaseNamespace(baseNamespaceEnv);
        this.localNameMap.put(BASE, this.baseNamespace);
        this.envirMap.put(baseNamespaceEnv, this.baseNamespace);
    }

    public Namespace getBaseNamespace() {
        return this.baseNamespace;
    }

    public Environment getBaseNamespaceEnv() {
        return this.getBaseNamespace().getNamespaceEnvironment();
    }

    public Namespace getNamespace(Environment envir) {
        Namespace ns = this.envirMap.get(envir);
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        return ns;
    }

    public Iterable<Symbol> getLoadedNamespaces() {
        return this.localNameMap.keySet();
    }

    public Optional<Namespace> getNamespaceIfPresent(Symbol name) {
        Collection<Namespace> matching = this.localNameMap.get(name);
        if (matching.size() == 1) {
            return Optional.of(matching.iterator().next());
        }
        return Optional.absent();
    }

    public Namespace getNamespace(Context context, String name) {
        return this.getNamespace(context, Symbol.get(name));
    }

    public Namespace getNamespace(Context context, Symbol symbol2) {
        FqPackageName candidate;
        if (symbol2.getPrintName().equals("base")) {
            return this.baseNamespace;
        }
        for (FqPackageName fqPackageName : this.namespaceMap.keySet()) {
            if (!symbol2.getPrintName().equals(fqPackageName.toString('.')) && !symbol2.getPrintName().equals(fqPackageName.getPackageName())) continue;
            return this.namespaceMap.get(fqPackageName);
        }
        if (CORE_PACKAGES.contains(symbol2.getPrintName())) {
            return this.getNamespace(context, FqPackageName.corePackage(symbol2));
        }
        ArrayList<FqPackageName> candidates = Lists.newArrayList();
        if (this.couldBeFullyQualified(symbol2)) {
            candidates.add(FqPackageName.fromSymbol(symbol2));
        }
        candidates.add(new FqPackageName("org.renjin.bioconductor", symbol2.getPrintName()));
        candidates.add(new FqPackageName("org.renjin.cran", symbol2.getPrintName()));
        Optional<Object> namespace = Optional.absent();
        Iterator i$ = candidates.iterator();
        while (i$.hasNext() && !(namespace = this.tryGetNamespace(context, candidate = (FqPackageName)i$.next())).isPresent()) {
        }
        if (!namespace.isPresent()) {
            throw new EvalException("Could not load package " + symbol2 + "; tried " + Joiner.on(", ").join(candidates), new Object[0]);
        }
        return (Namespace)namespace.get();
    }

    public static Set<String> getCorePackages() {
        return CORE_PACKAGES;
    }

    public Namespace getNamespace(Context context, FqPackageName fqPackageName) {
        Optional<Namespace> namespace = this.tryGetNamespace(context, fqPackageName);
        if (!namespace.isPresent()) {
            throw new EvalException("Could not load package " + fqPackageName, new Object[0]);
        }
        return namespace.get();
    }

    private Optional<Namespace> tryGetNamespace(Context context, FqPackageName fqName) {
        if (this.namespaceMap.containsKey(fqName)) {
            return Optional.of(this.namespaceMap.get(fqName));
        }
        return this.tryLoad(context, fqName);
    }

    private Optional<Namespace> tryLoad(Context context, FqPackageName fqName) {
        Optional<Package> loadResult = this.loader.load(fqName);
        if (!loadResult.isPresent()) {
            return Optional.absent();
        }
        Package pkg = loadResult.get();
        try {
            Namespace namespace = this.createNamespace(pkg);
            this.populateNamespace(context, pkg, namespace);
            CharSource namespaceSource = pkg.getResource("NAMESPACE").asCharSource(Charsets.UTF_8);
            NamespaceFile namespaceFile = NamespaceFile.parse(context, namespaceSource);
            namespace.initImports(context, this, namespaceFile);
            if (namespace.getNamespaceEnvironment().hasVariable(Symbol.get(".onLoad"))) {
                StringVector nameArgument = StringVector.valueOf(pkg.getName().getPackageName());
                context.evaluate(FunctionCall.newCall(Symbol.get(".onLoad"), nameArgument, nameArgument), namespace.getNamespaceEnvironment());
            }
            namespace.initExports(namespaceFile);
            namespace.registerS3Methods(context, namespaceFile);
            NamespaceRegistry.maybeUpdateS4MetadataCache(context, namespace);
            namespace.loaded = true;
            return Optional.of(namespace);
        }
        catch (Exception e) {
            throw new EvalException("IOException while loading package " + fqName + ": " + e.getMessage(), e);
        }
    }

    private boolean couldBeFullyQualified(Symbol name) {
        String string = name.getPrintName();
        return string.indexOf(58) != -1 || string.indexOf(46) != -1;
    }

    private void populateNamespace(Context context, Package pkg, Namespace namespace) throws IOException {
        for (NamedValue value : pkg.loadSymbols(context)) {
            namespace.getNamespaceEnvironment().setVariable(context, Symbol.get(value.getName()), value.getValue());
        }
    }

    private static void maybeUpdateS4MetadataCache(Context context, Namespace namespace) {
        if (namespace.getFullyQualifiedName().getGroupId().equals("org.renjin") && namespace.getFullyQualifiedName().getPackageName().equals("methods")) {
            return;
        }
        Optional<Namespace> methods = context.getNamespaceRegistry().getNamespaceIfPresent(Symbol.get("methods"));
        if (methods.isPresent() && methods.get().isLoaded()) {
            SEXP cacheFunction = methods.get().getEntry(Symbol.get("cacheMetaData"));
            FunctionCall cacheCall = FunctionCall.newCall(cacheFunction, namespace.getNamespaceEnvironment(), LogicalVector.TRUE, namespace.getNamespaceEnvironment());
            context.evaluate(cacheCall);
        }
    }

    public boolean isRegistered(Symbol name) {
        return this.localNameMap.containsKey(name);
    }

    public Namespace getBase() {
        return this.baseNamespace;
    }

    public Namespace createNamespace(Package pkg) {
        Environment imports = Environment.createNamedEnvironment(this.getBaseNamespaceEnv(), "imports:" + pkg.getName().toString('.')).build();
        Environment namespaceEnv = Environment.createNamespaceEnvironment(imports, pkg.getName().getPackageName()).build();
        Namespace namespace = new Namespace(pkg, namespaceEnv);
        this.localNameMap.put(pkg.getName().getPackageSymbol(), namespace);
        this.namespaceMap.put(pkg.getName(), namespace);
        this.envirMap.put(namespaceEnv, namespace);
        namespaceEnv.setVariableUnsafe(".packageName", (SEXP)StringVector.valueOf(pkg.getName().getPackageName()));
        return namespace;
    }

    public boolean isNamespaceEnv(Environment envir) {
        return this.envirMap.containsKey(envir);
    }
}

