/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset.lazy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.guava.primitives.Ints;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class ShadedColMatrix
extends DoubleVector
implements MemoizedComputation {
    private DoubleVector base = null;
    private int colheight = 1;
    private Map<Integer, DoubleVector> columnMap = new HashMap<Integer, DoubleVector>();
    private double[] result;

    public ShadedColMatrix(DoubleVector source) {
        super(source.getAttributes());
        this.base = source;
        SEXP dimr = this.base.getAttribute(Symbols.DIM);
        if (!(dimr instanceof IntArrayVector)) {
            throw new RuntimeException("non-integer dimensions? weird!");
        }
        this.colheight = ((IntArrayVector)dimr).getElementAsInt(0);
    }

    public ShadedColMatrix withShadedCol(int col2, DoubleVector elements) {
        return this.cloneWithNewAttributes(this.getAttributes()).setShadedCol(col2, elements);
    }

    public ShadedColMatrix setShadedCol(int col2, DoubleVector elements) {
        this.columnMap.put(col2, elements);
        return this;
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    protected ShadedColMatrix cloneWithNewAttributes(AttributeMap attributes2) {
        ShadedColMatrix clone = new ShadedColMatrix(this.base);
        clone.columnMap = new HashMap<Integer, DoubleVector>(this.columnMap);
        return clone;
    }

    @Override
    public double getElementAsDouble(int index) {
        int col2 = index / this.colheight + 1;
        int row2 = index % this.colheight;
        if (this.columnMap.containsKey(col2)) {
            return this.columnMap.get(col2).get(row2);
        }
        return this.base.get(index);
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public Vector[] getOperands() {
        ArrayList<AbstractAtomicVector> ops = new ArrayList<AbstractAtomicVector>();
        ops.add(this.base);
        ops.add(new IntArrayVector(Ints.toArray(this.columnMap.keySet())));
        ops.addAll(this.columnMap.values());
        return ops.toArray(new Vector[ops.size()]);
    }

    @Override
    public String getComputationName() {
        return "ShadedColMatrix";
    }

    @Override
    public Vector forceResult() {
        int numColumns = this.length() / this.colheight;
        double[] matrix2 = this.base.toDoubleArray();
        int index = 0;
        for (int col2 = 0; col2 < numColumns; ++col2) {
            DoubleVector column = this.columnMap.get(col2 + 1);
            if (column == null) {
                index += this.colheight;
                continue;
            }
            for (int row2 = 0; row2 < this.colheight; ++row2) {
                matrix2[index++] = column.getElementAsDouble(row2);
            }
        }
        this.result = matrix2;
        return DoubleArrayVector.unsafe(this.result, this.getAttributes());
    }

    @Override
    public void setResult(Vector result) {
        this.result = ((DoubleArrayVector)result).toDoubleArrayUnsafe();
    }

    @Override
    public boolean isCalculated() {
        return this.result != null;
    }
}

