/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.vector;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Vector;

public class ConvertingDoubleVector
extends DoubleVector
implements DeferredComputation {
    private final Vector operand;

    public ConvertingDoubleVector(Vector operand, AttributeMap attributes2) {
        super(attributes2);
        this.operand = operand;
    }

    public ConvertingDoubleVector(Vector operand) {
        this(operand, AttributeMap.EMPTY);
    }

    @Override
    public int length() {
        return this.operand.length();
    }

    @Override
    protected DoubleVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new ConvertingDoubleVector(this.operand, attributes2);
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.operand};
    }

    @Override
    public String getComputationName() {
        return "as.double";
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.operand.getElementAsDouble(index);
    }

    @Override
    public boolean isConstantAccessTime() {
        return this.operand.isConstantAccessTime();
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    public static double compute(double x) {
        return x;
    }

    @Override
    public double[] toDoubleArray() {
        double[] array2 = new double[this.length()];
        this.operand.copyTo(array2, 0, this.length());
        return array2;
    }
}

