/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import java.util.Collection;
import org.renjin.eval.Profiler;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public final class DoubleArrayVector
extends DoubleVector {
    public static DoubleArrayVector ZERO = new DoubleArrayVector(0.0);
    public static DoubleArrayVector ONE = new DoubleArrayVector(1.0);
    private double[] values;

    private DoubleArrayVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public static DoubleArrayVector valueOf(double x) {
        if (x == 0.0) {
            return ZERO;
        }
        if (x == 1.0) {
            return ONE;
        }
        return new DoubleArrayVector(x);
    }

    public DoubleArrayVector(double ... values) {
        this(values, AttributeMap.EMPTY);
    }

    public DoubleArrayVector(double value, AttributeMap attributes2) {
        this(new double[]{value}, 1, attributes2);
    }

    public DoubleArrayVector(double[] values, AttributeMap attributes2) {
        this(values, values.length, attributes2);
    }

    public DoubleArrayVector(double[] values, int length2, AttributeMap attributes2) {
        this(attributes2);
        if (Profiler.ENABLED) {
            Profiler.memoryAllocated(64, length2);
        }
        this.values = Arrays.copyOf(values, length2);
    }

    public DoubleArrayVector(Collection<Double> values) {
        this.values = new double[values.size()];
        int i = 0;
        for (Double value : values) {
            this.values[i++] = value;
        }
    }

    public DoubleArrayVector(DoubleVector vector2) {
        super(vector2.getAttributes());
        this.values = vector2.toDoubleArray();
    }

    public static DoubleArrayVector unsafe(double[] array2) {
        return DoubleArrayVector.unsafe(array2, AttributeMap.EMPTY);
    }

    public static DoubleArrayVector unsafe(double[] array2, AttributeMap attributes2) {
        DoubleArrayVector vector2 = new DoubleArrayVector(attributes2);
        vector2.values = array2;
        return vector2;
    }

    public static DoubleArrayVector unsafe(double[] array2, AttributeMap.Builder attributes2) {
        return DoubleArrayVector.unsafe(array2, attributes2.validateAndBuildForVectorOfLength(array2.length));
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        DoubleArrayVector clone = new DoubleArrayVector(attributes2);
        clone.values = this.values;
        return clone;
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.values[index];
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public Builder newCopyBuilder() {
        return new Builder(this);
    }

    @Override
    public Builder newBuilderWithInitialSize(int initialSize) {
        return new Builder(initialSize, initialSize);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new Builder(0, initialCapacity);
    }

    public static DoubleVector newMatrix(double[] values, int nRows, int nCols) {
        return new DoubleArrayVector(values, AttributeMap.builder().setDim(nRows, nCols).build());
    }

    @Override
    public boolean isElementNA(int index) {
        return DoubleArrayVector.isNA(this.values[index]);
    }

    @Override
    public boolean isElementNaN(int i) {
        return Double.isNaN(this.values[i]);
    }

    @Override
    public String toString() {
        return DoubleArrayVector.toString(this);
    }

    public double[] toDoubleArrayUnsafe() {
        return this.values;
    }

    @Override
    public double[] toDoubleArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public void copyTo(double[] array2, int offset, int length2) {
        System.arraycopy(array2, 0, array2, offset, length2);
    }

    static /* synthetic */ double[] access$102(DoubleArrayVector x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private static final int MIN_INITIAL_CAPACITY = 50;
        private double[] values;
        private int size;

        public Builder(int initialSize, int initialCapacity) {
            if (initialCapacity < 50) {
                initialCapacity = 50;
            }
            if (initialSize > initialCapacity) {
                initialCapacity = initialSize;
            }
            this.values = new double[initialCapacity];
            this.size = initialSize;
            Arrays.fill(this.values, DoubleVector.NA);
        }

        public Builder() {
            this(0, 50);
        }

        public Builder(int initialSize) {
            this(initialSize, initialSize);
        }

        public static Builder withInitialSize(int size) {
            return new Builder(size, size);
        }

        public static Builder withInitialCapacity(int capacity) {
            return new Builder(0, capacity);
        }

        public Builder(DoubleVector exp2) {
            this.values = exp2.toDoubleArray();
            this.size = this.values.length;
            this.copyAttributesFrom(exp2);
        }

        public Builder set(int index, double value) {
            this.ensureCapacity(index + 1);
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
            this.values[index] = value;
            return this;
        }

        public Builder add(double value) {
            return this.set(this.size, value);
        }

        @Override
        public Builder add(Number value) {
            return this.add(value.doubleValue());
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, Double.longBitsToDouble(9218868437227407266L));
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsDouble(sourceIndex));
        }

        public Builder set(int index, Double value) {
            return this.set(index, (double)value);
        }

        @Override
        public int length() {
            return this.size;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.values.length;
            if (minCapacity > oldCapacity) {
                double[] oldData = this.values;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.values = Arrays.copyOf(oldData, newCapacity);
                Arrays.fill(this.values, oldCapacity, this.values.length, DoubleVector.NA);
            }
        }

        @Override
        public DoubleVector build() {
            if (this.values.length == this.size) {
                if (Profiler.ENABLED) {
                    Profiler.memoryAllocated(64, this.values.length);
                }
                DoubleArrayVector vector2 = new DoubleArrayVector(this.buildAttributes());
                DoubleArrayVector.access$102(vector2, this.values);
                this.values = null;
                return vector2;
            }
            return new DoubleArrayVector(this.values, this.size, this.buildAttributes());
        }
    }
}

