/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.renjin.base.BaseFrame;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.Recursive;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Environment
extends AbstractSEXP
implements Recursive,
HasNamedValues {
    public static final String TYPE_NAME = "environment";
    private static final String GLOBAL_ENVIRONMENT_NAME = "R_GlobalEnv";
    private String name = null;
    private Environment parent;
    protected Frame frame;
    private boolean locked;
    private Set<Symbol> lockedBindings;
    private Map<Symbol, Closure> activeBindings = null;
    private Set<Symbol> missingArguments = null;
    public static final EmptyEnv EMPTY = new EmptyEnv();

    public static Environment createGlobalEnvironment(Environment baseEnvironment, Frame frame2) {
        Environment global = new Environment(frame2);
        global.name = GLOBAL_ENVIRONMENT_NAME;
        global.parent = baseEnvironment;
        return global;
    }

    public static Environment createGlobalEnvironment(Environment baseEnvironment) {
        return Environment.createGlobalEnvironment(baseEnvironment, new HashFrame());
    }

    public static Environment createBaseEnvironment() {
        Environment base = new Environment(new BaseFrame());
        base.name = "base";
        base.parent = EMPTY;
        return base;
    }

    public static Builder createChildEnvironment(Environment parent2) {
        return Environment.createChildEnvironment(parent2, new HashFrame());
    }

    public static Builder createNamespaceEnvironment(Environment parent2, String namespaceName) {
        Builder ns = Environment.createChildEnvironment(parent2);
        ns.name = "namespace:" + namespaceName;
        return ns;
    }

    public static Builder createNamedEnvironment(Environment parent2, String name) {
        Builder ns = Environment.createChildEnvironment(parent2);
        ns.name = name;
        return ns;
    }

    public static Builder createBaseNamespaceEnvironment(Environment globalEnv, Environment baseEnvironment) {
        Builder ns = Environment.createChildEnvironment(globalEnv, baseEnvironment.getFrame());
        ns.name = "namespace:base";
        return ns;
    }

    public static Builder createChildEnvironment(Environment parent2, Frame frame2) {
        return new Builder(parent2, frame2);
    }

    private Environment(Frame frame2) {
        this.frame = frame2;
    }

    private Environment() {
        this.frame = new HashFrame();
    }

    public Environment(AttributeMap attributes2) {
        super(attributes2);
        this.frame = new HashFrame();
    }

    public void setVariables(Context context, PairList pairList) {
        for (PairList.Node node : pairList.nodes()) {
            if (!node.hasTag()) {
                throw new IllegalArgumentException("All elements of pairList must be tagged");
            }
            this.setVariable(context, node.getTag(), node.getValue());
        }
    }

    public void remove(Symbol symbol2) {
        if (this.locked) {
            throw new EvalException("cannot remove bindings from a locked environment", new Object[0]);
        }
        if (this.isActiveBinding(symbol2)) {
            this.activeBindings.remove(symbol2);
        }
        this.frame.remove(symbol2);
    }

    public void clear() {
        this.frame.clear();
    }

    public String getName() {
        SEXP nameAttribute = this.getAttributes().get(Symbols.NAME);
        if (nameAttribute instanceof StringVector) {
            return ((StringVector)nameAttribute).getElementAsString(0);
        }
        if (this.name == null) {
            return Integer.toString(this.hashCode());
        }
        return this.name;
    }

    public Environment getParent() {
        return this.parent;
    }

    public void setParent(Environment parent2) {
        this.parent = parent2;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public Collection<Symbol> getSymbolNames() {
        ArrayList<Symbol> ordered = new ArrayList<Symbol>(this.frame.getSymbols());
        if (this.activeBindings != null) {
            ArrayList<Symbol> ordered2 = new ArrayList<Symbol>(this.activeBindings.keySet());
            ordered.addAll(ordered2);
        }
        Collections.sort(ordered, new Comparator<Symbol>(){

            @Override
            public int compare(Symbol o1, Symbol o2) {
                if (o1.getPrintName().startsWith(".") && !o2.getPrintName().startsWith(".")) {
                    return 1;
                }
                if (!o1.getPrintName().startsWith(".") && o2.getPrintName().startsWith(".")) {
                    return -1;
                }
                return o1.getPrintName().compareTo(o2.getPrintName());
            }
        });
        return ordered;
    }

    @Override
    public StringVector getNames() {
        StringVector.Builder names2 = new StringVector.Builder();
        for (Symbol name : this.getSymbolNames()) {
            names2.add(name.getPrintName());
        }
        return names2.build();
    }

    public boolean bindingIsLocked(Symbol symbol2) {
        return this.lockedBindings != null && this.lockedBindings.contains(symbol2);
    }

    public void setVariableUnsafe(Symbol symbol2, SEXP value) {
        this.frame.setVariable(symbol2, value);
    }

    public void setArgument(Symbol symbol2, SEXP value) {
        this.frame.setVariable(symbol2, value);
    }

    public void setMissingArgument(Symbol symbol2, SEXP defaultValue) {
        this.frame.setVariable(symbol2, defaultValue);
        if (this.missingArguments == null) {
            this.missingArguments = new HashSet<Symbol>();
        }
        this.missingArguments.add(symbol2);
    }

    public void setVariableUnsafe(String name, SEXP value) {
        if (StringVector.isNA(name)) {
            name = "NA";
        }
        this.setVariableUnsafe(Symbol.get(name), value);
    }

    @Deprecated
    public void setVariable(String name, SEXP value) {
        this.setVariableUnsafe(name, value);
    }

    @Deprecated
    public void setVariable(Symbol symbol2, SEXP value) {
        this.setVariableUnsafe(symbol2, value);
    }

    public SEXP setVariable(Context context, String name, SEXP value) {
        assert (context != null);
        if (StringVector.isNA(name)) {
            name = "NA";
        }
        return this.setVariable(context, Symbol.get(name), value);
    }

    public SEXP setVariable(Context context, Symbol symbol2, SEXP value) {
        assert (context != null);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Unbound: " + symbol2, new Object[0]);
        }
        if (this.bindingIsLocked(symbol2)) {
            throw new EvalException("cannot change value of locked binding for '%s'", symbol2.getPrintName());
        }
        if (this.activeBindings != null && this.activeBindings.containsKey(symbol2)) {
            Closure fun = this.activeBindings.get(symbol2);
            PairList.Builder args2 = new PairList.Builder().add(value);
            return context.evaluate(new FunctionCall(fun, args2.build()));
        }
        if (this.locked && this.frame.getVariable(symbol2) == Symbol.UNBOUND_VALUE) {
            throw new EvalException("cannot add bindings to a locked environment", new Object[0]);
        }
        this.frame.setVariable(symbol2, value);
        if (this.missingArguments != null) {
            this.missingArguments.remove(symbol2);
        }
        return Null.INSTANCE;
    }

    public void makeActiveBinding(Symbol symbol2, Closure closure) {
        if (this.bindingIsLocked(symbol2)) {
            throw new EvalException("cannot change value of locked binding for '%s'", symbol2.getPrintName());
        }
        if (this.locked && this.frame.getVariable(symbol2) == Symbol.UNBOUND_VALUE) {
            throw new EvalException("cannot add bindings to a locked environment", new Object[0]);
        }
        if (this.frame.getSymbols().contains(symbol2)) {
            throw new EvalException("Error in makeActiveBinding(%s, %s, %s) :\n   symbol already has a regular binding", symbol2.getPrintName(), closure.getTypeName(), closure.getEnclosingEnvironment().getTypeName());
        }
        if (this.activeBindings == null) {
            this.activeBindings = new HashMap<Symbol, Closure>();
        }
        this.activeBindings.put(symbol2, closure);
    }

    public boolean isActiveBinding(Symbol symbol2) {
        return this.activeBindings != null && this.activeBindings.containsKey(symbol2);
    }

    public boolean isActiveBinding(String name) {
        return this.isActiveBinding(Symbol.get(name));
    }

    public Closure getActiveBinding(Symbol symbol2) {
        return this.activeBindings.get(symbol2);
    }

    public SEXP findVariable(Context context, Symbol symbol2, Predicate<SEXP> predicate, boolean inherits2) {
        SEXP value = this.getVariable(context, symbol2);
        if (value != Symbol.UNBOUND_VALUE) {
            if (value instanceof Promise) {
                value = value.force(context);
            }
            if (predicate.apply(value)) {
                return value;
            }
        }
        if (inherits2) {
            return this.parent.findVariable(context, symbol2, predicate, inherits2);
        }
        return Symbol.UNBOUND_VALUE;
    }

    public SEXP findVariable(Context context, Symbol symbol2) {
        if (symbol2.isVarArgReference()) {
            return this.findVarArg(symbol2.getVarArgReferenceIndex());
        }
        if (this.activeBindings != null && this.activeBindings.containsKey(symbol2)) {
            return this.evaluateFunction(context, symbol2);
        }
        SEXP value = this.frame.getVariable(symbol2);
        if (value != Symbol.UNBOUND_VALUE) {
            return value;
        }
        return this.parent.findVariable(context, symbol2);
    }

    @Deprecated
    public SEXP findVariable(Symbol symbol2) {
        return this.findVariableUnsafe(symbol2);
    }

    public SEXP findVariableUnsafe(Symbol symbol2) {
        if (symbol2.isVarArgReference()) {
            return this.findVarArg(symbol2.getVarArgReferenceIndex());
        }
        assert (!this.isActiveBinding(symbol2));
        SEXP value = this.frame.getVariable(symbol2);
        if (value != Symbol.UNBOUND_VALUE) {
            return value;
        }
        return this.parent.findVariableUnsafe(symbol2);
    }

    private SEXP findVarArg(int varArgReferenceIndex) {
        SEXP ellipses = this.findVariableUnsafe(Symbols.ELLIPSES);
        if (ellipses == Symbol.UNBOUND_VALUE) {
            throw new EvalException("..%d used in an incorrect context, no ... to look in", varArgReferenceIndex);
        }
        PairList varArgs = (PairList)ellipses;
        if (varArgs.length() < varArgReferenceIndex) {
            throw new EvalException("The ... list does not contain %d items", varArgReferenceIndex);
        }
        return varArgs.getElementAsSEXP(varArgReferenceIndex - 1);
    }

    public SEXP findVariableOrThrow(Context context, Symbol symbol2) {
        SEXP value = this.findVariable(context, symbol2);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("object '" + symbol2.getPrintName() + "' not found", new Object[0]);
        }
        return value;
    }

    public Function findFunction(Context context, Symbol symbol2) {
        if (this.frame.isMissingArgument(symbol2)) {
            throw new EvalException("argument '%s' is missing, with no default", symbol2.toString());
        }
        Function value = this.frame.getFunction(context, symbol2);
        if (value != null) {
            return value;
        }
        return this.parent.findFunction(context, symbol2);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void lock(boolean lockBindings) {
        this.locked = true;
        if (lockBindings) {
            this.lockedBindings = Sets.newHashSet(this.frame.getSymbols());
            if (this.activeBindings != null) {
                this.lockedBindings.addAll(this.activeBindings.keySet());
            }
        }
    }

    @Override
    public int length() {
        int length2 = this.frame.getSymbols().size();
        if (this.activeBindings != null) {
            length2 += this.activeBindings.size();
        }
        return length2;
    }

    public boolean exists(Symbol symbol2) {
        return this.frame.getVariable(symbol2) != Symbol.UNBOUND_VALUE || this.isActiveBinding(symbol2);
    }

    public void lockBinding(Symbol symbol2) {
        if (!this.exists(symbol2)) {
            throw new EvalException("no binding for '%s'", symbol2);
        }
        if (this.lockedBindings == null) {
            this.lockedBindings = Sets.newHashSet();
        }
        this.lockedBindings.add(symbol2);
    }

    public void unlockBinding(Symbol symbol2) {
        if (!this.exists(symbol2)) {
            throw new EvalException("no binding for '%s'", symbol2);
        }
        if (this.lockedBindings != null) {
            this.lockedBindings.remove(symbol2);
        }
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    public Iterable<Environment> parents() {
        return new Iterable<Environment>(){

            @Override
            public Iterator<Environment> iterator() {
                return new EnvIterator(Environment.this.getParent());
            }
        };
    }

    @Deprecated
    public SEXP getVariable(String name) {
        return this.getVariableUnsafe(name);
    }

    @Deprecated
    public SEXP getVariable(Symbol symbol2) {
        return this.getVariableUnsafe(symbol2);
    }

    public SEXP getVariable(Context context, Symbol symbol2) {
        assert (context != null);
        if (this.activeBindings != null && this.activeBindings.containsKey(symbol2)) {
            return this.evaluateFunction(context, symbol2);
        }
        return this.frame.getVariable(symbol2);
    }

    public SEXP getVariable(Context context, String symbolName) {
        if (StringVector.isNA(symbolName)) {
            symbolName = "NA";
        }
        return this.getVariable(context, Symbol.get(symbolName));
    }

    public SEXP getVariableUnsafe(Symbol symbol2) {
        assert (!this.isActiveBinding(symbol2));
        return this.frame.getVariable(symbol2);
    }

    public SEXP getVariableUnsafe(String symbolName) {
        return this.getVariableUnsafe(Symbol.get(symbolName));
    }

    public SEXP getEllipsesVariable() {
        return this.getVariableUnsafe(Symbols.ELLIPSES);
    }

    public boolean hasVariable(Symbol symbol2) {
        return this.frame.getVariable(symbol2) != Symbol.UNBOUND_VALUE;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        this.unsafeSetAttributes(attributes2);
        return this;
    }

    public boolean isMissingArgument(Symbol symbol2) {
        if (this.missingArguments == null) {
            return false;
        }
        return this.missingArguments.contains(symbol2);
    }

    @Override
    public String toString() {
        return "<environment: " + this.getName() + ">";
    }

    public Environment insertAbove(Frame frame2) {
        Environment newEnv = Environment.createChildEnvironment(this.parent, frame2).build();
        this.setParent(newEnv);
        return newEnv;
    }

    @Override
    public Iterable<NamedValue> namedValues() {
        return new NamedValues();
    }

    private SEXP evaluateFunction(Context context, Symbol symbol2) {
        Closure fun = this.activeBindings.get(symbol2);
        PairList.Builder args2 = new PairList.Builder();
        return context.evaluate(new FunctionCall(fun, args2.build()));
    }

    public static class Builder {
        private final Environment parent;
        private final Frame frame;
        public String name;

        public Builder(Environment parent2, Frame frame2) {
            this.parent = parent2;
            this.frame = frame2;
        }

        public Builder setVariable(Symbol symbol2, SEXP value) {
            this.frame.setVariable(symbol2, value);
            return this;
        }

        public Environment build() {
            Environment child = new Environment(this.frame);
            child.parent = this.parent;
            return child;
        }
    }

    private static class BoundValue
    implements NamedValue {
        private Symbol name;
        private SEXP value;

        private BoundValue() {
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name.getPrintName();
        }

        @Override
        public SEXP getValue() {
            return this.value;
        }
    }

    private class NamedValueIterator
    extends UnmodifiableIterator<NamedValue> {
        private Iterator<Symbol> names;

        private NamedValueIterator() {
            this.names = Environment.this.getSymbolNames().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public NamedValue next() {
            BoundValue boundValue = new BoundValue();
            Symbol name = this.names.next();
            boundValue.name = name;
            boundValue.value = Environment.this.getVariableUnsafe(name);
            return boundValue;
        }
    }

    private class NamedValues
    implements Iterable<NamedValue> {
        private NamedValues() {
        }

        @Override
        public Iterator<NamedValue> iterator() {
            return new NamedValueIterator();
        }
    }

    private static class EmptyEnv
    extends Environment {
        private EmptyEnv() {
        }

        @Override
        public Collection<Symbol> getSymbolNames() {
            return Collections.emptySet();
        }

        @Override
        public SEXP findVariable(Context context, Symbol symbol2, Predicate<SEXP> predicate, boolean inherits2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public SEXP findVariable(Context context, Symbol symbol2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public SEXP findVariableUnsafe(Symbol symbol2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public SEXP getVariable(Context context, Symbol symbol2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public Function findFunction(Context context, Symbol symbol2) {
            return null;
        }

        @Override
        public Environment getParent() {
            throw new UnsupportedOperationException("The empty environment does not have a parent.");
        }

        @Override
        public void setParent(Environment parent2) {
            throw new UnsupportedOperationException("The empty environment does not have a parent.");
        }
    }

    private static class EnvIterator
    extends UnmodifiableIterator<Environment> {
        private Environment next;

        private EnvIterator(Environment next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != EMPTY;
        }

        @Override
        public Environment next() {
            Environment toReturn = this.next;
            this.next = this.next.parent;
            return toReturn;
        }
    }
}

