/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import java.util.Iterator;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.repackaged.guava.primitives.UnsignedBytes;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.Vector;

public class RawVector
extends AbstractAtomicVector
implements Iterable<Byte> {
    public static final String TYPE_NAME = "raw";
    public static final Vector.Type VECTOR_TYPE = new RawType();
    public static final RawVector EMPTY = new RawVector(new byte[0]);
    public static int NUM_BITS = 8;
    private byte[] values;

    public RawVector(byte ... values) {
        this.values = new byte[values.length];
        this.values = Arrays.copyOf(values, values.length);
    }

    public RawVector(byte[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = new byte[values.length];
        this.values = Arrays.copyOf(values, values.length);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.values.length];
        System.arraycopy(this.values, 0, bytes, 0, this.values.length);
        return bytes;
    }

    public byte[] toByteArrayUnsafe() {
        return this.values;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public byte getElementAsByte(int index) {
        return this.values[index];
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.getElementAsInt(index);
    }

    @Override
    public int getElementAsInt(int index) {
        return UnsignedBytes.toInt(this.values[index]);
    }

    @Override
    public String getElementAsString(int index) {
        return RawVector.toString(this.values[index]);
    }

    public static String toString(byte value) {
        int intValue = UnsignedBytes.toInt(value);
        if (intValue <= 15) {
            return "0" + Integer.toHexString(intValue);
        }
        return Integer.toHexString(intValue);
    }

    public static byte cast(int value) {
        if (value < 0 || value > 255) {
            return 0;
        }
        return (byte)value;
    }

    @Override
    public int getElementAsRawLogical(int index) {
        return this.values[index] == 0 ? 0 : 1;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new RawVector(this.values, attributes2);
    }

    public SEXP getElementAsSEXP(int index) {
        return new RawVector(this.values[index]);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    @Override
    public Builder newBuilderWithInitialSize(int initialSize) {
        return new Builder(initialSize);
    }

    @Override
    public Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new Builder(0);
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public Builder newCopyBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean isElementNA(int index) {
        return false;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public Object getElementAsObject(int index) {
        return this.values[index];
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int compare(int index1, int index2) {
        return UnsignedBytes.compare(this.values[index1], this.values[index2]);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ValueIterator();
    }

    @Override
    public String toString() {
        if (this.values.length == 1) {
            return this.getElementAsString(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        for (int i = 0; i != this.length(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getElementAsString(i));
        }
        return sb.append(")").toString();
    }

    private class ValueIterator
    extends UnmodifiableIterator<Byte> {
        private int i = 0;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < RawVector.this.values.length;
        }

        @Override
        public Byte next() {
            return RawVector.this.values[this.i++];
        }
    }

    private static class RawType
    extends Vector.Type {
        private RawType() {
            super(1);
        }

        @Override
        public Vector.Builder newBuilder() {
            return new Builder(0);
        }

        @Override
        public Builder newBuilderWithInitialSize(int initialSize) {
            return new Builder(initialSize);
        }

        @Override
        public Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new Builder(0);
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new RawVector(vector2.getElementAsByte(index));
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            return UnsignedBytes.compare(vector1.getElementAsByte(index1), vector2.getElementAsByte(index2));
        }

        @Override
        public boolean elementsIdentical(Vector vector1, int index1, Vector vector2, int index2) {
            return vector1.getElementAsByte(index1) == vector2.getElementAsByte(index2);
        }

        @Override
        public Vector to(Vector x) {
            byte[] bytes = new byte[x.length()];
            for (int i = 0; i < x.length(); ++i) {
                bytes[i] = x.getElementAsByte(i);
            }
            return new RawVector(bytes, x.getAttributes());
        }
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private byte[] values;

        public Builder(int initialSize) {
            this.values = new byte[initialSize];
        }

        private Builder(RawVector exp2) {
            this.values = Arrays.copyOf(exp2.values, exp2.values.length);
            this.copyAttributesFrom(exp2);
        }

        public Builder() {
            this.values = new byte[0];
        }

        public Builder set(int index, byte value) {
            if (this.values.length <= index) {
                this.values = Arrays.copyOf(this.values, index + 1);
            }
            this.values[index] = value;
            return this;
        }

        public Builder add(byte value) {
            return this.set(this.values.length, value);
        }

        @Override
        public Builder add(Number value) {
            return this.add(UnsignedBytes.checkedCast(value.longValue()));
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, (byte)0);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, RawVector.cast(source.getElementAsInt(sourceIndex)));
        }

        @Override
        public int length() {
            return this.values.length;
        }

        @Override
        public RawVector build() {
            return new RawVector(this.values, this.buildAttributes());
        }
    }
}

