/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceTriangle
extends DoubleVector
implements DeferredComputation {
    private Vector vector;
    private int length;
    private int size;

    public Euclidean1dDistanceTriangle(Vector vector2, AttributeMap attributeMap) {
        super(attributeMap);
        this.vector = vector2;
        this.size = vector2.length();
        this.length = this.size * (this.size - 1) / 2;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributeMap) {
        return new Euclidean1dDistanceTriangle(this.vector, attributeMap);
    }

    @Override
    public String getComputationName() {
        return "dist";
    }

    @Override
    public double getElementAsDouble(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4;
        while (n >= n2 + (n4 = this.size - n3 - 1)) {
            n2 += n4;
            ++n3;
        }
        return Math.abs(this.vector.getElementAsDouble(n3 + 1 + (n - n2)) - this.vector.getElementAsDouble(n3));
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    public Vector getVector() {
        return this.vector;
    }

    @Override
    public boolean isConstantAccessTime() {
        return this.vector.isConstantAccessTime();
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }
}

