/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.List;
import org.renjin.primitives.Indexes;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.stats.internals.models.ModelMatrixColumn;

public class ModelMatrix
extends DoubleVector {
    public static final Symbol ASSIGN = Symbol.get("assign");
    private int numRows = 0;
    private List<ModelMatrixColumn> columns;

    public ModelMatrix(int numRows, List<ModelMatrixColumn> columns, AttributeMap attributes2) {
        super(attributes2);
        this.numRows = numRows;
        this.columns = columns;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new ModelMatrix(this.numRows, this.columns, attributes2);
    }

    @Override
    public double getElementAsDouble(int index) {
        int col2 = Indexes.vectorIndexToCol(index, this.numRows, this.columns.size());
        int row2 = Indexes.vectorIndexToRow(index, this.numRows);
        return this.columns.get(col2).getValue(row2);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.numRows * this.columns.size();
    }

    @Override
    public int hashCode() {
        return 37 * this.numRows + this.columns.hashCode();
    }
}

