/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.correlation;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class Covariance {
    private final RealMatrix covarianceMatrix;
    private final int n;

    public Covariance() {
        this.covarianceMatrix = null;
        this.n = 0;
    }

    public Covariance(double[][] data, boolean biasCorrected) {
        this(new BlockRealMatrix(data), biasCorrected);
    }

    public Covariance(double[][] data) {
        this(data, true);
    }

    public Covariance(RealMatrix matrix2, boolean biasCorrected) {
        this.checkSufficientData(matrix2);
        this.n = matrix2.getRowDimension();
        this.covarianceMatrix = this.computeCovarianceMatrix(matrix2, biasCorrected);
    }

    public Covariance(RealMatrix matrix2) {
        this(matrix2, true);
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int getN() {
        return this.n;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix2, boolean biasCorrected) {
        int dimension = matrix2.getColumnDimension();
        Variance variance = new Variance(biasCorrected);
        BlockRealMatrix outMatrix = new BlockRealMatrix(dimension, dimension);
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                double cov = this.covariance(matrix2.getColumn(i), matrix2.getColumn(j), biasCorrected);
                outMatrix.setEntry(i, j, cov);
                outMatrix.setEntry(j, i, cov);
            }
            outMatrix.setEntry(i, i, variance.evaluate(matrix2.getColumn(i)));
        }
        return outMatrix;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix2) {
        return this.computeCovarianceMatrix(matrix2, true);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data, boolean biasCorrected) {
        return this.computeCovarianceMatrix(new BlockRealMatrix(data), biasCorrected);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data) {
        return this.computeCovarianceMatrix(data, true);
    }

    public double covariance(double[] xArray, double[] yArray, boolean biasCorrected) throws IllegalArgumentException {
        Mean mean2 = new Mean();
        double result = 0.0;
        int length2 = xArray.length;
        if (length2 != yArray.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, length2, yArray.length);
        }
        if (length2 < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, length2, 2);
        }
        double xMean = mean2.evaluate(xArray);
        double yMean = mean2.evaluate(yArray);
        for (int i = 0; i < length2; ++i) {
            double xDev = xArray[i] - xMean;
            double yDev = yArray[i] - yMean;
            result += (xDev * yDev - result) / (double)(i + 1);
        }
        return biasCorrected ? result * ((double)length2 / (double)(length2 - 1)) : result;
    }

    public double covariance(double[] xArray, double[] yArray) throws IllegalArgumentException {
        return this.covariance(xArray, yArray, true);
    }

    private void checkSufficientData(RealMatrix matrix2) {
        int nRows = matrix2.getRowDimension();
        int nCols = matrix2.getColumnDimension();
        if (nRows < 2 || nCols < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, nRows, nCols);
        }
    }
}

