/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic {
    public double evaluate(double[] values) {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        return this.evaluate(values, 0, values.length);
    }

    public double evaluate(double[] values, int begin, int length2) {
        if (this.test(values, begin, length2)) {
            this.clear();
            this.incrementAll(values, begin, length2);
        }
        return this.getResult();
    }

    public abstract StorelessUnivariateStatistic copy();

    public abstract void clear();

    public abstract double getResult();

    public abstract void increment(double var1);

    public void incrementAll(double[] values) {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        this.incrementAll(values, 0, values.length);
    }

    public void incrementAll(double[] values, int begin, int length2) {
        if (this.test(values, begin, length2)) {
            int k = begin + length2;
            for (int i = begin; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (!(object2 instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic stat = (AbstractStorelessUnivariateStatistic)object2;
        return MathUtils.equalsIncludingNaN(stat.getResult(), this.getResult()) && MathUtils.equalsIncludingNaN(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

