/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class CompositeFormat
extends Format {
    private static final long serialVersionUID = 5358685519349262494L;

    protected static NumberFormat getDefaultNumberFormat() {
        return CompositeFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    protected static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(2);
        return nf;
    }

    protected void parseAndIgnoreWhitespace(String source, ParsePosition pos) {
        this.parseNextCharacter(source, pos);
        pos.setIndex(pos.getIndex() - 1);
    }

    protected char parseNextCharacter(String source, ParsePosition pos) {
        int index = pos.getIndex();
        int n = source.length();
        char ret = '\u0000';
        if (index < n) {
            char c2;
            while (Character.isWhitespace(c2 = source.charAt(index++)) && index < n) {
            }
            pos.setIndex(index);
            if (index < n) {
                ret = c2;
            }
        }
        return ret;
    }

    private Number parseNumber(String source, double value, ParsePosition pos) {
        Double ret = null;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(value);
        sb.append(')');
        int n = sb.length();
        int startIndex = pos.getIndex();
        int endIndex = startIndex + n;
        if (endIndex < source.length() && source.substring(startIndex, endIndex).compareTo(sb.toString()) == 0) {
            ret = value;
            pos.setIndex(endIndex);
        }
        return ret;
    }

    protected Number parseNumber(String source, NumberFormat format2, ParsePosition pos) {
        int startIndex = pos.getIndex();
        Number number2 = format2.parse(source, pos);
        int endIndex = pos.getIndex();
        if (startIndex == endIndex) {
            double[] special = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            for (int i = 0; i < special.length && (number2 = this.parseNumber(source, special[i], pos)) == null; ++i) {
            }
        }
        return number2;
    }

    protected boolean parseFixedstring(String source, String expected, ParsePosition pos) {
        int startIndex = pos.getIndex();
        int endIndex = startIndex + expected.length();
        if (startIndex >= source.length() || endIndex > source.length() || source.substring(startIndex, endIndex).compareTo(expected) != 0) {
            pos.setIndex(startIndex);
            pos.setErrorIndex(startIndex);
            return false;
        }
        pos.setIndex(endIndex);
        return true;
    }

    protected StringBuffer formatDouble(double value, NumberFormat format2, StringBuffer toAppendTo, FieldPosition pos) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            toAppendTo.append('(');
            toAppendTo.append(value);
            toAppendTo.append(')');
        } else {
            format2.format(value, toAppendTo, pos);
        }
        return toAppendTo;
    }
}

