/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.Collections;
import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.DataParallelCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.StaticMethodCall;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.invoke.codegen.OverloadComparator;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Primitives;

public class AnnotationBasedSpecializer
implements BuiltinSpecializer {
    private final Primitives.Entry primitive;
    private final String genericGroup;
    private final List<JvmMethod> methods;

    public AnnotationBasedSpecializer(Primitives.Entry primitive2) {
        this.primitive = primitive2;
        this.methods = JvmMethod.findOverloads(this.primitive.functionClass, this.primitive.name, this.primitive.methodName);
        this.genericGroup = AnnotationBasedSpecializer.findGenericGroup(this.methods);
        Collections.sort(this.methods, new OverloadComparator());
    }

    @Override
    public String getName() {
        return this.primitive.name;
    }

    @Override
    public String getGroup() {
        return this.genericGroup;
    }

    private static String findGenericGroup(List<JvmMethod> methods) {
        for (JvmMethod method : methods) {
            if (!method.isGroupGeneric()) continue;
            return method.getGenericGroup();
        }
        return null;
    }

    public boolean isGeneric() {
        for (JvmMethod method : this.methods) {
            if (!method.isGeneric()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> namedArguments) {
        List<ValueBounds> arguments = ArgumentBounds.withoutNames(namedArguments);
        JvmMethod method = this.selectOverload(arguments);
        if (method == null) {
            return UnspecializedCall.INSTANCE;
        }
        if (method.isDataParallel()) {
            return new DataParallelCall(this.primitive, method, arguments).specializeFurther();
        }
        if (StaticMethodCall.isEligible(method)) {
            return new StaticMethodCall(method).furtherSpecialize(arguments);
        }
        return UnspecializedCall.INSTANCE;
    }

    private JvmMethod selectOverload(List<ValueBounds> argumentTypes) {
        for (JvmMethod method : this.methods) {
            if (!this.matches(method, argumentTypes)) continue;
            return method;
        }
        return null;
    }

    private boolean matches(JvmMethod method, List<ValueBounds> argumentTypes) {
        if (!this.arityMatches(method, argumentTypes)) {
            return false;
        }
        for (int i = 0; i < method.getPositionalFormals().size(); ++i) {
            JvmMethod.Argument formal = method.getPositionalFormals().get(i);
            ValueBounds actualType = argumentTypes.get(i);
            if (TypeSet.matches(formal.getClazz(), actualType.getTypeSet())) continue;
            return false;
        }
        return true;
    }

    private boolean arityMatches(JvmMethod method, List<ValueBounds> argumentTypes) {
        int numPosArgs = method.getPositionalFormals().size();
        return argumentTypes.size() == numPosArgs || method.acceptsArgumentList() && argumentTypes.size() >= numPosArgs;
    }
}

