/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;

public class DoubleBinaryOp
implements Specialization {
    private int opcode;
    private ValueBounds valueBounds;

    public DoubleBinaryOp(int opcode, ValueBounds valueBounds) {
        this.opcode = opcode;
        this.valueBounds = valueBounds;
    }

    @Override
    public Type getType() {
        return Type.DOUBLE_TYPE;
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.valueBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        assert (arguments.size() == 2);
        Expression x = arguments.get(0).getExpression();
        Expression y = arguments.get(1).getExpression();
        x.load(emitContext, mv);
        emitContext.convert(mv, x.getType(), Type.DOUBLE_TYPE);
        y.load(emitContext, mv);
        emitContext.convert(mv, y.getType(), Type.DOUBLE_TYPE);
        mv.visitInsn(this.opcode);
    }

    @Override
    public boolean isPure() {
        return true;
    }

    public static DoubleBinaryOp trySpecialize(String name, JvmMethod overload, ValueBounds resultBounds) {
        List<JvmMethod.Argument> formals2 = overload.getPositionalFormals();
        if (formals2.size() == 2 && formals2.get(0).getClazz().equals(Double.TYPE) && formals2.get(0).getClazz().equals(Double.TYPE)) {
            switch (name) {
                case "+": {
                    return new DoubleBinaryOp(99, resultBounds);
                }
                case "-": {
                    return new DoubleBinaryOp(103, resultBounds);
                }
                case "*": {
                    return new DoubleBinaryOp(107, resultBounds);
                }
                case "/": {
                    return new DoubleBinaryOp(111, resultBounds);
                }
            }
        }
        return null;
    }
}

