/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.CompleteSubset;
import org.renjin.compiler.builtins.GetAtomicElement;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.sexp.Symbol;

public class SubsetSpecializer
implements Specializer,
BuiltinSpecializer {
    @Override
    public String getName() {
        return "[";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        ValueBounds source = arguments.get(0).getBounds();
        List<ValueBounds> subscripts = ArgumentBounds.withoutNames(arguments.subList(1, arguments.size()));
        if (subscripts.size() == 0) {
            return new CompleteSubset(source);
        }
        if (subscripts.size() > 1) {
            return UnspecializedCall.INSTANCE;
        }
        ValueBounds subscript = subscripts.get(0);
        if (subscript.isConstant() && subscript.getConstantValue() == Symbol.MISSING_ARG) {
            return new CompleteSubset(source);
        }
        if (GetAtomicElement.accept(source, subscript)) {
            return new GetAtomicElement(source, subscript);
        }
        return UnspecializedCall.INSTANCE;
    }
}

