/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicLong;
import org.renjin.compiler.CompiledBody;
import org.renjin.compiler.CompiledLoopBody;
import org.renjin.compiler.JitClassLoader;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableSlots;
import org.renjin.compiler.ir.exception.InternalCompilerException;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.eval.Context;
import org.renjin.repackaged.asm.ClassVisitor;
import org.renjin.repackaged.asm.ClassWriter;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Opcodes;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.asm.tree.MethodNode;
import org.renjin.repackaged.asm.util.Textifier;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;

public class ByteCodeEmitter
implements Opcodes {
    private static final AtomicLong CLASS_COUNTER = new AtomicLong(1L);
    private ClassWriter cw;
    private ClassVisitor cv;
    private ControlFlowGraph cfg;
    private String className;
    private TypeSolver types;

    public ByteCodeEmitter(ControlFlowGraph cfg, TypeSolver types) {
        this.cfg = cfg;
        this.types = types;
        this.className = "Body" + CLASS_COUNTER.getAndIncrement();
    }

    public Class<CompiledBody> compile() {
        this.startClass(CompiledBody.class);
        this.writeImplementation();
        this.writeConstructor();
        this.writeClassEnd();
        return JitClassLoader.defineClass(CompiledBody.class, this.className.replace('/', '.'), this.cw.toByteArray());
    }

    public Class<CompiledLoopBody> compileLoopBody() {
        this.startClass(CompiledLoopBody.class);
        this.writeLoopImplementation();
        this.writeConstructor();
        this.writeClassEnd();
        return JitClassLoader.defineClass(CompiledLoopBody.class, this.className.replace('/', '.'), this.cw.toByteArray());
    }

    private void startClass(Class<?> interfaceClass) {
        this.cw = new ClassWriter(2);
        this.cv = this.cw;
        this.cv.visit(50, 33, this.className, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(interfaceClass)});
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void writeImplementation() {
        int argumentSize = 3;
        VariableSlots variableSlots = new VariableSlots(argumentSize, this.types);
        EmitContext emitContext = new EmitContext(this.cfg, argumentSize, variableSlots);
        MethodVisitor mv = this.cv.visitMethod(1, "evaluate", Type.getMethodDescriptor(Type.getType(SEXP.class), Type.getType(Context.class), Type.getType(Environment.class)), null, null);
        Textifier p = new Textifier();
        mv.visitCode();
        ByteCodeEmitter.writeBody(emitContext, mv, this.cfg);
        mv.visitEnd();
        try (PrintWriter pw = new PrintWriter(System.out);){
            p.print(pw);
        }
    }

    private void writeLoopImplementation() {
        MethodNode methodNode;
        int argumentSize = 5;
        VariableSlots variableSlots = new VariableSlots(argumentSize, this.types);
        EmitContext emitContext = new EmitContext(this.cfg, argumentSize, variableSlots);
        emitContext.setLoopVectorIndex(3);
        emitContext.setLoopIterationIndex(4);
        MethodNode mv = methodNode = new MethodNode(1, "run", Type.getMethodDescriptor(Type.getType(SEXP.class), Type.getType(Context.class), Type.getType(Environment.class), Type.getType(SEXP.class), Type.INT_TYPE), null, null);
        Textifier p = new Textifier();
        ((MethodVisitor)mv).visitCode();
        ByteCodeEmitter.writeBody(emitContext, mv, this.cfg);
        ((MethodVisitor)mv).visitEnd();
        PrintWriter pw = new PrintWriter(System.out);
        p.print(pw);
        pw.flush();
        methodNode.accept(this.cv);
    }

    public static void writeBody(EmitContext emitContext, MethodVisitor mv, ControlFlowGraph cfg) {
        InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            if (!basicBlock.isLive() || basicBlock == cfg.getEntry() || basicBlock == cfg.getExit()) continue;
            for (IRLabel label : basicBlock.getLabels()) {
                mv.visitLabel(emitContext.getAsmLabel(label));
            }
            for (Statement stmt : basicBlock.getStatements()) {
                try {
                    stmt.emit(emitContext, instructionAdapter);
                }
                catch (NotCompilableException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InternalCompilerException("Exception compiling statement " + stmt, e);
                }
            }
        }
        emitContext.writeDone(instructionAdapter);
        mv.visitMaxs(0, emitContext.getLocalVariableCount());
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }
}

