/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.S3Specialization;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.sexp.FunctionCall;

public class UseMethodCall
implements Expression {
    private RuntimeState runtimeState;
    private FunctionCall call;
    private final String generic;
    private final List<IRArgument> arguments;
    private Expression objectExpr;
    private Specialization specialization = UnspecializedCall.INSTANCE;

    public UseMethodCall(RuntimeState runtimeState, FunctionCall call2, String generic, Expression objectExpr) {
        this.runtimeState = runtimeState;
        this.call = call2;
        this.generic = generic;
        this.objectExpr = objectExpr;
        this.arguments = Collections.singletonList(new IRArgument(objectExpr));
    }

    @Override
    public boolean isPure() {
        return this.specialization.isPure();
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        this.specialization.load(emitContext, mv, this.arguments);
        return 0;
    }

    @Override
    public Type getType() {
        return this.specialization.getType();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        ValueBounds objectBounds = typeMap.get(this.objectExpr);
        this.specialization = S3Specialization.trySpecialize(this.generic, this.runtimeState, objectBounds, ArgumentBounds.create(this.arguments, typeMap));
        return this.specialization.getResultBounds();
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.specialization.getResultBounds();
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex == 0) {
            this.objectExpr = child;
        } else {
            this.arguments.get(childIndex - 1).setExpression(child);
        }
    }

    @Override
    public int getChildCount() {
        return 1 + this.arguments.size();
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            return this.objectExpr;
        }
        return this.arguments.get(index - 1).getExpression();
    }

    public String toString() {
        return "UseMethod(" + this.generic + ", " + this.objectExpr + ", " + Joiner.on(", ").join(this.arguments) + ")";
    }
}

