/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import java.util.ArrayList;
import java.util.List;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.ClosureCall;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Symbol;

public class ClosureCallTranslator
extends FunctionCallTranslator {
    private final Closure function;

    public ClosureCallTranslator(Closure function2) {
        this.function = function2;
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        List<IRArgument> arguments = builder.translateArgumentList(context, call2.getArguments());
        return new ClosureCall(builder.getRuntimeState(), call2, this.function, this.functionName(call2), arguments);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        builder.addStatement(new ExprStatement(this.translateToExpression(builder, context, resolvedFunction, call2)));
    }

    @Override
    public Expression translateToSetterExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall getterCall, Expression rhs) {
        ArrayList<IRArgument> setterArguments = new ArrayList<IRArgument>();
        setterArguments.addAll(builder.translateArgumentList(context, getterCall.getArguments()));
        setterArguments.add(new IRArgument("value", rhs));
        String functionName = this.functionName(getterCall) + "<-";
        return new ClosureCall(builder.getRuntimeState(), getterCall, (Closure)resolvedFunction, functionName, setterArguments);
    }

    private String functionName(FunctionCall call2) {
        if (call2.getFunction() instanceof Symbol) {
            return ((Symbol)call2.getFunction()).getPrintName();
        }
        return "fn";
    }
}

