/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Collections;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;

public class Assignment
implements Statement {
    private LValue lhs;
    private Expression rhs;

    public Assignment(LValue lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public LValue getLHS() {
        return this.lhs;
    }

    @Override
    public Expression getRHS() {
        return this.rhs;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    @Override
    public void setRHS(Expression newRHS) {
        this.rhs = newRHS;
    }

    public String toString() {
        return this.getLHS() + " " + "\u2190" + " " + this.rhs;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            return this.rhs;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException("childIndex=" + childIndex);
        }
        this.rhs = child;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitAssignment(this);
    }

    @Override
    public int emit(EmitContext emitContext, InstructionAdapter mv) {
        VariableStorage storage = emitContext.getVariableStorage(this.lhs);
        if (storage == null) {
            return 0;
        }
        Type rhsType = this.rhs instanceof LValue ? emitContext.getVariableStorage((LValue)this.rhs).getType() : this.rhs.getType();
        int stackIncrease = this.rhs.load(emitContext, mv);
        emitContext.convert(mv, rhsType, storage.getType());
        mv.visitVarInsn(storage.getType().getOpcode(54), storage.getSlotIndex());
        return stackIncrease;
    }

    @Override
    public boolean isPure() {
        return this.rhs.isPure();
    }

    public void setLHS(LValue lhs) {
        this.lhs = lhs;
    }
}

