/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class MatchedArguments {
    private SEXP[] actualTags;
    private final SEXP[] actualValues;
    private final MatchedArgumentPositions matchedPositions;

    public MatchedArguments(MatchedArgumentPositions matchedPositions, SEXP[] actualTags, SEXP[] actualValues) {
        this.actualTags = actualTags;
        this.actualValues = actualValues;
        this.matchedPositions = matchedPositions;
    }

    public int getFormalCount() {
        return this.matchedPositions.getFormalCount();
    }

    public boolean isFormalEllipses(int formalIndex) {
        return this.matchedPositions.getFormalName(formalIndex) == Symbols.ELLIPSES;
    }

    public Symbol getFormalName(int formalIndex) {
        return this.matchedPositions.getFormalName(formalIndex);
    }

    public PromisePairList buildExtraArgumentList() {
        PromisePairList.Builder promises = new PromisePairList.Builder();
        for (int actualIndex = 0; actualIndex < this.actualValues.length; ++actualIndex) {
            if (!this.matchedPositions.isExtraArgument(actualIndex)) continue;
            promises.add(this.actualTags[actualIndex], this.actualValues[actualIndex]);
        }
        return promises.build();
    }

    public int getActualIndex(int formalIndex) {
        return this.matchedPositions.getActualIndex(formalIndex);
    }

    public SEXP getActualValue(int actualIndex) {
        return this.actualValues[actualIndex];
    }
}

