/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.pnbeta;
import org.renjin.nmath.pnchisq;

public class pnf {
    private pnf() {
    }

    public static double pnf(double d, double d2, double d3, double d4, int n, int n2) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0 || Builtins.__isnan(d4) != 0) {
            d = d + d3 + d2 + d4;
        } else if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            d = Double.NaN;
        } else if (Builtins.__finite(d4) == 0) {
            d = Double.NaN;
        } else if (Builtins.__finite(d2) == 0 && Builtins.__finite(d3) == 0) {
            d = Double.NaN;
        } else if (d <= 0.0) {
            d = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
        } else if (d >= Double.POSITIVE_INFINITY) {
            d = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else if (d3 > 1.0E8) {
            d = pnchisq.pnchisq(d * d2, d2, d4, n, n2);
        } else {
            d = d2 / d3 * d;
            d = pnbeta.Rf_pnbeta2(d / (d + 1.0), 1.0 / (d + 1.0), d2 / 2.0, d3 / 2.0, d4, n, n2);
        }
        return d;
    }
}

