/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.qbeta;
import org.renjin.nmath.qchisq;

public class qf {
    private qf() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qf(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan(d) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3;
        if (d2 <= 0.0) return Double.NaN;
        if (d3 <= 0.0) return Double.NaN;
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == 1.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        }
        if (d2 <= d3 && d3 > 400000.0) {
            if (Builtins.__finite(d2) == 0) return 1.0;
            return qchisq.qchisq(d, d2, n, n2) / d2;
        }
        if (d2 > 400000.0) {
            n = n != 0 ? 0 : 1;
            return d3 / qchisq.qchisq(d, d3, n, n2);
        }
        n = n != 0 ? 0 : 1;
        d = (1.0 / qbeta.qbeta(d, d3 / 2.0, d2 / 2.0, n, n2) - 1.0) * (d3 / d2);
        if (Builtins.__isnan(d) == 0) return d;
        return Double.NaN;
    }
}

