/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import org.renjin.compiler.JitClassLoader;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.VectorPipeliner;
import org.renjin.pipeliner.fusion.kernel.CompiledKernel;
import org.renjin.pipeliner.fusion.kernel.LoopKernel;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.ClassVisitor;
import org.renjin.repackaged.asm.ClassWriter;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.tree.MethodNode;
import org.renjin.repackaged.asm.util.Textifier;
import org.renjin.repackaged.asm.util.TraceMethodVisitor;
import org.renjin.repackaged.guava.io.Files;

public class LoopKernelCompiler
implements Callable<CompiledKernel> {
    public static final boolean DEBUG = System.getProperty("renjin.vp.jit.debug") != null;
    private static final String KERNEL_INTERFACE = Type.getInternalName(CompiledKernel.class);
    private final LoopKernel kernel;
    private final LoopNode[] operands;
    private String className;
    private ClassVisitor cv;

    public LoopKernelCompiler(LoopKernel kernel, LoopNode[] operands) {
        this.kernel = kernel;
        this.operands = operands;
        this.className = "Jit" + System.identityHashCode(this);
    }

    @Override
    public CompiledKernel call() {
        long startTime = System.nanoTime();
        ClassWriter cw = new ClassWriter(3);
        this.cv = cw;
        this.cv.visit(50, 33, this.className, null, "java/lang/Object", new String[]{KERNEL_INTERFACE});
        this.writeConstructor();
        if (DEBUG) {
            this.writeComputeDebug(this.kernel, this.operands);
        } else {
            this.writeCompute(this.kernel, this.operands);
        }
        this.cv.visitEnd();
        byte[] classBytes = cw.toByteArray();
        long compileTime = System.nanoTime() - startTime;
        Class<CompiledKernel> jitClass = JitClassLoader.defineClass(CompiledKernel.class, this.className, classBytes);
        long loadTime = System.nanoTime() - startTime - compileTime;
        if (VectorPipeliner.DEBUG) {
            System.out.println(this.className + ": compile: " + (double)compileTime / 1000000.0 + "ms");
            System.out.println(this.className + ": load: " + (double)loadTime / 1000000.0 + "ms");
            if (DEBUG) {
                try {
                    File classFile = File.createTempFile("Specialization", ".class");
                    Files.write(classBytes, classFile);
                    System.out.println("Wrote class file to " + classFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            return jitClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke jitted computation", e);
        }
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeCompute(LoopKernel kernel, LoopNode[] operands) {
        String typeDescriptor = "([Lorg/renjin/sexp/Vector;)[D";
        MethodVisitor mv = this.cv.visitMethod(1, "compute", typeDescriptor, null, null);
        ComputeMethod methodContext = new ComputeMethod(mv);
        kernel.compute(methodContext, operands);
        mv.visitMaxs(1, methodContext.getMaxLocals());
        mv.visitEnd();
    }

    private void writeComputeDebug(LoopKernel kernel, LoopNode[] operands) {
        MethodNode mv = new MethodNode(1, "compute", "([Lorg/renjin/sexp/Vector;)[D", null, null);
        mv.visitCode();
        ComputeMethod methodContext = new ComputeMethod(mv);
        kernel.compute(methodContext, operands);
        mv.visitMaxs(1, methodContext.getMaxLocals());
        mv.visitEnd();
        try {
            mv.accept(this.cv);
            if (DEBUG) {
                System.out.println(this.toString(mv));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Toxic bytecode generated: " + this.toString(mv), e);
        }
    }

    private String toString(MethodNode methodNode) {
        try {
            Textifier p = new Textifier();
            methodNode.accept(new TraceMethodVisitor(p));
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                p.print(pw);
            }
            return sw.toString();
        }
        catch (Exception e) {
            return "<Exception generating bytecode: " + e.getClass().getName() + ": " + e.getMessage() + ">";
        }
    }
}

