/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.guava.base.Optional;

public class TransposeNode
extends LoopNode {
    private final LoopNode operand;
    private final LoopNode sourceRowCount;
    private int sourceRowCountLocal;
    private int sourceColCountLocal;

    public TransposeNode(LoopNode operand, LoopNode sourceRowCount) {
        this.operand = operand;
        this.sourceRowCount = sourceRowCount;
    }

    @Override
    public void init(ComputeMethod method) {
        this.operand.init(method);
        this.sourceRowCount.init(method);
        this.sourceRowCountLocal = method.reserveLocal(1);
        this.sourceColCountLocal = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        this.operand.pushLength(method);
        mv.visitInsn(3);
        this.sourceRowCount.pushElementAsInt(method, Optional.absent());
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.sourceRowCountLocal);
        mv.visitInsn(108);
        mv.visitVarInsn(54, this.sourceColCountLocal);
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.sourceColCountLocal);
        mv.visitInsn(108);
        mv.visitInsn(95);
        mv.visitVarInsn(21, this.sourceColCountLocal);
        mv.visitInsn(112);
        mv.visitVarInsn(21, this.sourceRowCountLocal);
        mv.visitInsn(104);
        mv.visitInsn(96);
        this.operand.pushElementAsDouble(method, integerNaLabel);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operand.pushLength(method);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return false;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("t(");
        this.operand.appendToKey(key);
        key.append(';');
        this.sourceRowCount.appendToKey(key);
        key.append(')');
    }

    public String toString() {
        return "t(" + this.operand + ")";
    }
}

