/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.node;

import java.util.List;
import java.util.Set;
import org.renjin.pipeliner.node.NodeShape;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Vector;

public abstract class DeferredNode {
    private List<DeferredNode> operands = Lists.newArrayList();
    private Set<DeferredNode> uses = Sets.newIdentityHashSet();

    public int addInput(DeferredNode node) {
        this.operands.add(node);
        return this.operands.size() - 1;
    }

    public void addInputs(DeferredNode[] array2) {
        for (int i = 0; i < array2.length; ++i) {
            DeferredNode input = array2[i];
            this.operands.add(input);
            input.uses.add(this);
        }
    }

    public void addOutput(DeferredNode node) {
        this.uses.add(node);
    }

    public abstract String getDebugLabel();

    public List<DeferredNode> getOperands() {
        return this.operands;
    }

    public void replaceOperands(DeferredNode ... operands) {
        this.operands = Lists.newArrayList(operands);
    }

    public String getDebugId() {
        return "N" + Integer.toHexString(System.identityHashCode(this));
    }

    public abstract NodeShape getShape();

    public String toString() {
        if (this.operands.isEmpty()) {
            return this.getDebugLabel();
        }
        return this.getDebugLabel() + "(" + Joiner.on(", ").join(this.operands) + ")";
    }

    public abstract Type getResultVectorType();

    public boolean hasValue(double x) {
        return false;
    }

    public DeferredNode getOperand(int index) {
        return this.getOperands().get(index);
    }

    public void replaceOperand(DeferredNode toReplace, DeferredNode replacementValue) {
        for (int i = 0; i != this.operands.size(); ++i) {
            if (this.operands.get(i) != toReplace) continue;
            this.operands.set(i, replacementValue);
            replacementValue.addOutput(this);
        }
    }

    public void removeUse(DeferredNode node) {
        this.uses.remove(node);
    }

    public void replaceUse(DeferredNode node, DeferredNode replacementValue) {
        if (this.uses.remove(node)) {
            this.uses.add(replacementValue);
        }
    }

    public boolean isUsed() {
        return !this.uses.isEmpty();
    }

    public Vector getVector() {
        throw new UnsupportedOperationException("getVector(): " + this.getClass().getName());
    }

    public void setResult(Vector result) {
        throw new UnsupportedOperationException();
    }

    public Set<DeferredNode> getUses() {
        return this.uses;
    }

    public final boolean isLeaf() {
        return this.operands.isEmpty();
    }
}

