/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.ConditionException;
import org.renjin.eval.ConditionHandler;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.RestartException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class Conditions {
    private Conditions() {
    }

    @Internal(value=".addCondHands")
    public static void addConditionHandlers(@Current Context context, StringVector classes, ListVector handlers, Environment parentEnv, SEXP target, boolean calling) {
        if (classes.length() != handlers.length()) {
            throw new EvalException("bad handler data", new Object[0]);
        }
        int n = handlers.length();
        for (int i = n - 1; i >= 0; --i) {
            context.setConditionHandler(classes.getElementAsString(i), Promise.repromise(parentEnv, handlers.getElementAsSEXP(i)), calling);
        }
    }

    @Internal(value=".addRestart")
    public static void addRestart(@Current Context context, SEXP restart) {
        context.addRestart(restart);
    }

    @Internal(value=".getRestart")
    public static SEXP getRestart(@Current Context context, int index) {
        return context.getRestart(index - 1);
    }

    @Internal(value=".invokeRestart")
    public static SEXP invokeRestart(@Current Context context, ListVector restart, ListVector arguments) {
        SEXP handler = restart.getElementAsSEXP("handler");
        if (!(handler instanceof Function)) {
            throw new EvalException("restart$handler is not a function", new Object[0]);
        }
        SEXP exitEnvironment = restart.getElementAsSEXP("exit");
        if (!(exitEnvironment instanceof Environment)) {
            throw new EvalException("restart$exit is not an environment", new Object[0]);
        }
        throw new RestartException((Environment)exitEnvironment, (Function)handler, arguments);
    }

    @Internal(value=".signalCondition")
    public static void signalCondition(@Current Context context, SEXP condition, String message, SEXP call2) {
        StringVector conditionClasses = condition.getS3Class();
        Context definitionContext = context.getConditionStack();
        while (!definitionContext.isTopLevel()) {
            for (String conditionClass : conditionClasses) {
                ConditionHandler handler = definitionContext.getConditionHandler(conditionClass);
                if (handler == null) continue;
                if (handler.isCalling()) {
                    FunctionCall handlerCall = FunctionCall.newCall(handler.getFunction(), condition);
                    context.evaluateCallingHandler(definitionContext, handlerCall);
                    continue;
                }
                throw new ConditionException(condition, definitionContext, handler.getFunction());
            }
            definitionContext = definitionContext.getParent();
        }
    }

    @Internal(value=".dfltStop")
    public static void defaultStop(@Current Context context, String message, FunctionCall call2) {
        EvalException e = new EvalException(message, new Object[0]);
        e.initContext(context);
        throw e;
    }

    @Internal(value=".dfltStop")
    public static void defaultStop(@Current Context context, String message, Null nz) {
        EvalException e = new EvalException(message, new Object[0]);
        e.initContext(context);
        throw e;
    }

    @Internal
    public static void stop(@Current Context context, boolean call2, String message) {
        throw new EvalException(message, new Object[0]);
    }

    @Internal
    public static String geterrmessage(@Current Context context) {
        ErrorMessage errorMessage = context.getSession().getSingleton(ErrorMessage.class);
        return errorMessage.getValue();
    }

    @Internal
    public static void seterrmessage(@Current Context context, String message) {
        ErrorMessage errorMessage = context.getSession().getSingleton(ErrorMessage.class);
        errorMessage.setValue(message);
    }

    public static class ErrorMessage {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

