/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.graphics.internals.Graphics;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class R$primitive$grconvertX
extends BuiltinFunction {
    public R$primitive$grconvertX() {
        super("grconvertX");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            SEXP s2 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$grconvertX.doApply(context, environment2, s0, s1, s2);
            }
            throw new EvalException("grconvertX: too many arguments, expected at most 3.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tgrconvertX(double, integer, integer)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 3) {
                return R$primitive$grconvertX.doApply(context, environment2, args2[0], args2[1], args2[2]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("grconvertX: max arity is 3", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$grconvertX.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1, SEXP arg2) throws Exception {
        if (arg0 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && (arg1 instanceof IntVector || arg1 instanceof DoubleVector || arg1 instanceof LogicalVector) && (arg2 instanceof IntVector || arg2 instanceof DoubleVector || arg2 instanceof LogicalVector)) {
            int cycles;
            Vector vector1 = WrapperRuntime.convertToVector(arg0);
            int length1 = vector1.length();
            int currentElementIndex1 = 0;
            Vector vector2 = WrapperRuntime.convertToVector(arg1);
            int length2 = vector2.length();
            int currentElementIndex2 = 0;
            Vector vector3 = WrapperRuntime.convertToVector(arg2);
            int length3 = vector3.length();
            int currentElementIndex3 = 0;
            if (length1 == 0 || length2 == 0 || length3 == 0) {
                cycles = 0;
            } else {
                cycles = 0;
                if (length1 > cycles) {
                    cycles = length1;
                }
                if (length2 > cycles) {
                    cycles = length2;
                }
                if (length3 > cycles) {
                    cycles = length3;
                }
            }
            DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                double s1 = vector1.getElementAsDouble(currentElementIndex1);
                int s2 = vector2.getElementAsInt(currentElementIndex2);
                int s3 = vector3.getElementAsInt(currentElementIndex3);
                if (Double.isNaN(s1) || IntVector.isNA(s2) || IntVector.isNA(s3)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, Graphics.grconvertX(context, s1, s2, s3));
                }
                if (++currentElementIndex1 == length1) {
                    currentElementIndex1 = 0;
                }
                if (++currentElementIndex2 == length2) {
                    currentElementIndex2 = 0;
                }
                if (++currentElementIndex3 != length3) continue;
                currentElementIndex3 = 0;
            }
            if (length1 == cycles) {
                builder.combineStructuralAttributesFrom(vector1);
            }
            if (length2 == cycles) {
                builder.combineStructuralAttributesFrom(vector2);
            }
            if (length3 == cycles) {
                builder.combineStructuralAttributesFrom(vector3);
            }
            return builder.build();
        }
        throw new EvalException(String.format("Invalid argument:\n\tgrconvertX(%s, %s, %s)\n\tExpected:\n\tgrconvertX(double, integer, integer)", arg0.getTypeName(), arg1.getTypeName(), arg2.getTypeName()), new Object[0]);
    }
}

