/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.renjin.appl.Appl;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Sort {
    @Internal
    public static Null sort(Null x, boolean decreasing) {
        return x;
    }

    @Internal
    public static Vector sort(StringVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        Object[] sorted = x.toArray();
        if (decreasing) {
            Arrays.sort(sorted, Collections.reverseOrder());
        } else {
            Arrays.sort(sorted);
        }
        return new StringArrayVector((String[])sorted);
    }

    @Internal
    public static Vector sort(DoubleVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        double[] sorted = x.toDoubleArray();
        Arrays.sort(sorted);
        if (decreasing) {
            Sort.reverse(sorted);
        }
        return DoubleArrayVector.unsafe(sorted);
    }

    private static void reverse(double[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            double temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    @Internal
    public static IntArrayVector sort(IntVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        int[] sorted = x.toIntArray();
        Arrays.sort(sorted);
        if (decreasing) {
            Sort.reverse(sorted);
        }
        return new IntArrayVector(sorted);
    }

    @Internal
    public static Vector sort(LogicalVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        int[] sorted = x.toIntArray();
        Arrays.sort(sorted);
        if (decreasing) {
            Sort.reverse(sorted);
        }
        return new LogicalArrayVector(sorted);
    }

    @Internal(value="is.unsorted")
    public static boolean isUnsorted(AtomicVector x, boolean strictly) {
        for (int i = 1; i < x.length(); ++i) {
            int z = x.compare(i - 1, i);
            if (z > 0) {
                return true;
            }
            if (!strictly || z != 0) continue;
            return true;
        }
        return false;
    }

    @Internal(value="findInterval")
    public static SEXP findInterval(DoubleArrayVector vec, DoubleArrayVector x, LogicalVector rightmostClosed, LogicalVector allInside, LogicalVector leftOpen) {
        int n = vec.length();
        int nx = x.length();
        IntArrayVector.Builder ans = new IntArrayVector.Builder(nx);
        DoublePtr vecPtr = new DoublePtr(vec.toDoubleArray(), 0);
        IntPtr mfl = new IntPtr(0);
        int ii = 1;
        for (int i = 0; i < nx; ++i) {
            ii = x.get(i) != x.get(i) ? Integer.MIN_VALUE : Appl.findInterval2(vecPtr, n, x.get(i), rightmostClosed.asInt(), allInside.asInt(), leftOpen.asInt(), ii, mfl);
            ans.set(i, ii);
        }
        return ans.build();
    }

    @Internal(value="is.unsorted")
    public static LogicalVector isUnsorted(ListVector x, boolean strictly) {
        if (x.length() <= 1) {
            return LogicalVector.FALSE;
        }
        return LogicalVector.NA_VECTOR;
    }

    @Internal(value="is.unsorted")
    public static LogicalVector isUnsorted(PairList.Node pairlist2, boolean strict) {
        if (pairlist2 instanceof FunctionCall) {
            throw new EvalException("invalid argument (language)", new Object[0]);
        }
        return Sort.isUnsorted(pairlist2.toVector(), strict);
    }

    @Internal(value="is.unsorted")
    public static LogicalVector isUnsorted(Symbol symbol2, boolean strict) {
        return LogicalVector.FALSE;
    }

    @Internal
    public static DoubleVector qsort(DoubleVector x, LogicalVector returnIndexes) {
        if (returnIndexes.isElementTrue(0)) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        double[] values = x.toDoubleArray();
        Arrays.sort(values);
        DoubleArrayVector sorted = new DoubleArrayVector(values, x.getAttributes());
        return (DoubleVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static DoubleVector psort(DoubleVector x, Vector indexes) {
        return Sort.qsort(x, LogicalVector.FALSE);
    }

    @Internal
    public static IntVector qsort(IntVector x, LogicalVector returnIndexes) {
        if (returnIndexes.isElementTrue(0)) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        int[] values = x.toIntArray();
        Arrays.sort(values);
        IntArrayVector sorted = new IntArrayVector(values, x.getAttributes());
        return (IntVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static IntVector psort(IntVector x, Vector indexes) {
        return Sort.qsort(x, LogicalVector.FALSE);
    }

    @Internal
    public static LogicalVector qsort(LogicalVector x, boolean returnIndexes) {
        if (returnIndexes) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        int[] array2 = x.toIntArray();
        Arrays.sort(array2);
        LogicalArrayVector sorted = new LogicalArrayVector(array2, x.getAttributes());
        return (LogicalVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static LogicalVector psort(LogicalVector x, Vector indexes) {
        return Sort.qsort(x, false);
    }

    private static void reverse(int[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            int temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    @Internal
    public static Vector order(final boolean naLast, final boolean decreasing, final @ArgumentList ListVector columns) {
        if (columns.length() == 0) {
            return Null.INSTANCE;
        }
        int numRows = columns.getElementAsSEXP(0).length();
        for (int i = 0; i != columns.length(); ++i) {
            if (columns.getElementAsSEXP(i).length() == numRows) continue;
            throw new EvalException("argument lengths differ", new Object[0]);
        }
        ArrayList<Integer> ordering = Lists.newArrayListWithCapacity(numRows);
        for (int i = 0; i != numRows; ++i) {
            ordering.add(i);
        }
        Collections.sort(ordering, new Comparator<Integer>(){

            @Override
            public int compare(Integer row1, Integer row2) {
                int rel;
                int col2 = 0;
                while ((rel = this.compare(row1, row2, col2)) == 0) {
                    if (++col2 != columns.length()) continue;
                    return 0;
                }
                return rel;
            }

            private int compare(Integer row1, Integer row2, int col2) {
                AtomicVector column = (AtomicVector)columns.get(col2);
                boolean na1 = column.isElementNA(row1);
                boolean na2 = column.isElementNA(row2);
                if (na1 && na2) {
                    return 0;
                }
                if (na1) {
                    return naLast ? 1 : -1;
                }
                if (na2) {
                    return naLast ? -1 : 1;
                }
                return decreasing ? -column.compare(row1, row2) : column.compare(row1, row2);
            }
        });
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (Integer index : ordering) {
            result.add(index + 1);
        }
        return result.build();
    }

    @Internal(value="which.min")
    public static IntVector whichMin(Vector input) {
        int minIndex = -1;
        double minValue = 0.0;
        for (int i = 0; i < input.length(); ++i) {
            double value = input.getElementAsDouble(i);
            if (Double.isNaN(value) || minIndex != -1 && !(value < minValue)) continue;
            minValue = input.getElementAsDouble(i);
            minIndex = i;
        }
        if (minIndex >= 0) {
            return new IntArrayVector(new int[]{minIndex + 1}, Sort.whichName(input, minIndex));
        }
        return IntVector.EMPTY;
    }

    @Internal(value="which.max")
    public static IntVector whichMax(Vector input) {
        int maxIndex = -1;
        double maxValue = 0.0;
        for (int i = 0; i < input.length(); ++i) {
            double value = input.getElementAsDouble(i);
            if (Double.isNaN(value) || maxIndex != -1 && !(value > maxValue)) continue;
            maxValue = input.getElementAsDouble(i);
            maxIndex = i;
        }
        if (maxIndex >= 0) {
            return new IntArrayVector(new int[]{maxIndex + 1}, Sort.whichName(input, maxIndex));
        }
        return IntVector.EMPTY;
    }

    private static AttributeMap whichName(Vector v, int index) {
        AttributeMap attributes2;
        AtomicVector names2 = v.getNames();
        if (names2 != Null.INSTANCE) {
            String maxName = names2.getElementAsString(index);
            attributes2 = AttributeMap.newBuilder().setNames(new StringArrayVector(maxName)).build();
        } else {
            attributes2 = AttributeMap.EMPTY;
        }
        return attributes2;
    }

    @Internal
    public static Vector rank(AtomicVector input, String tiesMethod) {
        AtomicVector sortedInput;
        String typeVector;
        boolean decreasing = false;
        switch (typeVector = input.getTypeName()) {
            case "character": {
                StringVector inputStringVector = (StringVector)input.setAttributes(AttributeMap.EMPTY);
                sortedInput = (AtomicVector)Sort.sort(inputStringVector, decreasing);
                break;
            }
            case "double": {
                DoubleVector inputDoubleVector = (DoubleVector)input.setAttributes(AttributeMap.EMPTY);
                sortedInput = (AtomicVector)Sort.sort(inputDoubleVector, decreasing);
                break;
            }
            default: {
                IntVector inputIntVector = (IntVector)input.setAttributes(AttributeMap.EMPTY);
                sortedInput = Sort.sort(inputIntVector, decreasing);
            }
        }
        switch (tiesMethod.toUpperCase()) {
            case "MIN": {
                return Sort.rankMin(input, sortedInput);
            }
            case "MAX": {
                return Sort.rankMax(input, sortedInput);
            }
            case "AVERAGE": {
                return Sort.rankAverage(input, sortedInput);
            }
            case "FIRST": {
                throw new EvalException("ties.method=first not implemented", new Object[0]);
            }
            case "RANDOM": {
                throw new EvalException("ties.method=random not implemented", new Object[0]);
            }
        }
        throw new EvalException("Invalid ties.method.", new Object[0]);
    }

    private static Vector rankAverage(AtomicVector input, AtomicVector sortedInput) {
        DoubleArrayVector.Builder ranks = new DoubleArrayVector.Builder();
        for (int i = 0; i < sortedInput.length(); ++i) {
            int minRank;
            int maxRank = minRank = sortedInput.indexOf(input, i, 0);
            while (maxRank + 1 < sortedInput.length() && sortedInput.compare(minRank, maxRank + 1) == 0) {
                ++maxRank;
            }
            double average = ((double)minRank + (double)maxRank) / 2.0;
            ranks.add(average + 1.0);
        }
        return ranks.build();
    }

    private static Vector rankMax(AtomicVector input, AtomicVector sortedInput) {
        IntArrayVector.Builder ranks = new IntArrayVector.Builder();
        for (int i = 0; i < sortedInput.length(); ++i) {
            int minRank;
            int maxRank = minRank = sortedInput.indexOf(input, i, 0);
            while (maxRank + 1 < sortedInput.length() && sortedInput.compare(minRank, maxRank + 1) == 0) {
                ++maxRank;
            }
            ranks.add(maxRank + 1);
        }
        return ranks.build();
    }

    private static Vector rankMin(AtomicVector input, AtomicVector sortedInput) {
        IntArrayVector.Builder ranks = new IntArrayVector.Builder();
        for (int i = 0; i < sortedInput.length(); ++i) {
            ranks.add(sortedInput.indexOf(input, i, 0) + 1);
        }
        return ranks.build();
    }

    @Builtin
    @Generic
    public static SEXP xtfrm(@Current Context context, SEXP x) {
        FunctionCall defaultCall = FunctionCall.newCall(Symbol.get("xtfrm.default"), x);
        return context.evaluate(defaultCall);
    }
}

