/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.Arrays;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.reflection.converters.BooleanArrayConverter;
import org.renjin.invoke.reflection.converters.BooleanConverter;
import org.renjin.invoke.reflection.converters.DoubleArrayConverter;
import org.renjin.invoke.reflection.converters.DoubleConverter;
import org.renjin.invoke.reflection.converters.IntegerArrayConverter;
import org.renjin.invoke.reflection.converters.IntegerConverter;
import org.renjin.invoke.reflection.converters.StringArrayConverter;
import org.renjin.invoke.reflection.converters.StringConverter;
import org.renjin.primitives.CollectionUtils;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.vector.ConvertingDoubleVector;
import org.renjin.primitives.vector.ConvertingStringVector;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.base.Predicates;
import org.renjin.sexp.AbstractVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Vectors {
    @Builtin(value="length<-")
    public static Vector setLength(Vector source, int length2) {
        if (length2 < 0) {
            throw new EvalException("%d : invalid value", length2);
        }
        if (source == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        Vector.Builder copy2 = source.newBuilderWithInitialSize(length2);
        for (int i = 0; i != Math.min(length2, source.length()); ++i) {
            copy2.setFrom(i, source, i);
        }
        AtomicVector sourceNames = source.getNames();
        if (sourceNames != Null.INSTANCE) {
            StringVector.Builder newNames = new StringVector.Builder();
            for (int i = 0; i < length2; ++i) {
                if (i < source.length()) {
                    newNames.add(sourceNames.getElementAsString(i));
                    continue;
                }
                newNames.add("");
            }
            copy2.setAttribute(Symbols.NAMES, (SEXP)newNames.build());
        }
        return copy2.build();
    }

    @Generic
    @Builtin
    public static int length(SEXP exp2) {
        if (exp2 instanceof S4Object && exp2.getAttribute(Symbols.DOT_XDATA) instanceof Environment) {
            return exp2.getAttribute(Symbols.DOT_XDATA).length();
        }
        return exp2.length();
    }

    @Generic
    @Builtin(value="as.character")
    public static StringVector asCharacter(PairList.Node source) {
        return Vectors.convertToStringVector(null, new StringVector.Builder(), source.toVector());
    }

    @Generic
    @Builtin(value="as.character")
    public static StringVector asCharacter() {
        return StringArrayVector.EMPTY;
    }

    @Generic
    @Builtin(value="as.character")
    public static StringVector asCharacter(@Current Context context, Vector source) {
        if (source instanceof StringVector) {
            return (StringVector)source.setAttributes(AttributeMap.EMPTY);
        }
        if (source.length() < 100) {
            return Vectors.convertToStringVector(context, new StringVector.Builder(), source);
        }
        return new ConvertingStringVector(source);
    }

    private static StringVector convertToStringVector(Context context, StringVector.Builder builder, Vector source) {
        if (source instanceof ListVector) {
            for (int i = 0; i != source.length(); ++i) {
                SEXP value = ((ListVector)source).getElementAsSEXP(i);
                if (value instanceof AtomicVector && value.length() == 1) {
                    builder.addFrom((AtomicVector)value, 0);
                    continue;
                }
                builder.add(Deparse.deparseExp(context, value));
            }
        } else {
            for (int i = 0; i != source.length(); ++i) {
                builder.addFrom(source, i);
            }
        }
        return builder.build();
    }

    @Generic
    @Builtin(value="as.character")
    public static StringVector asCharacter(Symbol symbol2) {
        return StringVector.valueOf(symbol2.getPrintName());
    }

    @Generic
    @Builtin(value="as.character")
    public static StringVector asCharacter(ExternalPtr<?> ptr) {
        Object instance = ptr.getInstance();
        if (StringConverter.accept(instance.getClass())) {
            return (StringVector)StringConverter.INSTANCE.convertToR((String)instance);
        }
        if (StringArrayConverter.accept(instance.getClass())) {
            return (StringVector)StringArrayConverter.INSTANCE.convertToR(instance);
        }
        return StringArrayVector.valueOf(ptr.getInstance().toString());
    }

    @Generic
    @Builtin(value="as.logical")
    public static LogicalVector asLogical(ExternalPtr ptr) {
        Object instance = ptr.getInstance();
        Class<?> clazz = instance.getClass();
        if (BooleanConverter.accept(clazz)) {
            return BooleanConverter.INSTANCE.convertToR((Boolean)instance);
        }
        if (BooleanArrayConverter.accept(clazz)) {
            return BooleanArrayConverter.INSTANCE.convertToR((Boolean[])instance);
        }
        return new LogicalArrayVector(Logical.NA);
    }

    @Generic
    @Builtin(value="as.logical")
    public static LogicalVector asLogical(Vector vector2) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector(vector2, "logical");
        return (LogicalVector)Vectors.convertToAtomicVector(new LogicalArrayVector.Builder(), vector2);
    }

    @Generic
    @Builtin(value="as.logical")
    public static LogicalVector asLogical() {
        return LogicalArrayVector.EMPTY;
    }

    @Generic
    @Builtin(value="as.logical")
    public static LogicalVector asLogical(PairList.Node pairlist2) {
        return Vectors.asLogical(pairlist2.toVector());
    }

    @Generic
    @Builtin(value="as.integer")
    public static IntVector asInteger(ExternalPtr ptr) {
        Object instance = ptr.getInstance();
        Class<?> clazz = instance.getClass();
        if (IntegerConverter.accept(clazz)) {
            return (IntVector)IntegerConverter.INSTANCE.convertToR((Number)instance);
        }
        if (IntegerArrayConverter.accept(clazz)) {
            return (IntVector)IntegerArrayConverter.INSTANCE.convertToR((Number[])instance);
        }
        return IntVector.valueOf(Integer.MIN_VALUE);
    }

    @Generic
    @Builtin(value="as.integer")
    public static IntVector asInteger(Vector source) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector(source, "integer");
        return (IntVector)Vectors.convertToAtomicVector(new IntArrayVector.Builder(), source);
    }

    @Generic
    @Builtin(value="as.integer")
    public static IntVector asInteger() {
        return IntArrayVector.EMPTY;
    }

    @Generic
    @Builtin(value="as.integer")
    public static IntVector asInteger(PairList.Node pairlist2) {
        return Vectors.asInteger(pairlist2.toVector());
    }

    @Generic
    @Builtin(value="as.double")
    public static DoubleVector asDouble(ExternalPtr ptr) {
        Object instance = ptr.getInstance();
        Class<?> clazz = instance.getClass();
        if (DoubleConverter.accept(clazz)) {
            return (DoubleVector)DoubleConverter.INSTANCE.convertToR(instance);
        }
        if (DoubleArrayConverter.DOUBLE_ARRAY.accept(clazz)) {
            return DoubleArrayConverter.DOUBLE_ARRAY.convertToR(instance);
        }
        return new DoubleArrayVector(DoubleVector.NA);
    }

    @Generic
    @Builtin(value="as.double")
    public static DoubleVector asDouble(Vector source) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector(source, "double");
        if (source instanceof DoubleVector) {
            return (DoubleVector)source.setAttributes(AttributeMap.EMPTY);
        }
        if (source.isDeferred() || source.length() > 100) {
            return new ConvertingDoubleVector(source);
        }
        return (DoubleVector)Vectors.convertToAtomicVector(new DoubleArrayVector.Builder(), source);
    }

    @Generic
    @Builtin(value="as.double")
    public static DoubleVector asDouble(PairList.Node pairlist2) {
        return Vectors.asDouble(pairlist2.toVector());
    }

    @Generic
    @Builtin(value="as.double")
    public static DoubleVector asDouble() {
        return DoubleArrayVector.EMPTY;
    }

    @Generic
    @Builtin(value="as.raw")
    public static RawVector asRaw(Vector source) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector(source, "raw");
        return (RawVector)Vectors.convertToAtomicVector(new RawVector.Builder(), source);
    }

    @Generic
    @Builtin(value="as.raw")
    public static RawVector asRaw(PairList.Node source) {
        return Vectors.asRaw(source.toVector());
    }

    static Vector convertToAtomicVector(Vector.Builder builder, Vector source) {
        if (source instanceof ListVector) {
            for (int i = 0; i != source.length(); ++i) {
                SEXP value = ((ListVector)source).getElementAsSEXP(i);
                if (value instanceof AtomicVector && value.length() == 1) {
                    builder.addFrom(value, 0);
                    continue;
                }
                builder.addNA();
            }
        } else {
            for (int i = 0; i != source.length(); ++i) {
                builder.addFrom(source, i);
            }
        }
        return builder.build();
    }

    @Generic
    @Builtin(value="as.complex")
    public static ComplexVector asComplex(Vector vector2) {
        if (vector2 instanceof DoubleVector) {
            return Vectors.doubleToComplex((DoubleVector)vector2);
        }
        Vectors.checkForListThatCannotBeCoercedToAtomicVector(vector2, "");
        return (ComplexVector)Vectors.convertToAtomicVector(new ComplexArrayVector.Builder(), vector2);
    }

    @Generic
    @Builtin(value="as.complex")
    public static ComplexVector asComplex() {
        return ComplexArrayVector.EMPTY;
    }

    @Generic
    @Builtin(value="as.complex")
    public static ComplexVector asComplex(PairList.Node pairlist2) {
        return Vectors.asComplex(pairlist2.toVector());
    }

    @Generic
    @Internal(value="as.vector")
    public static SEXP asVector(Vector x, String mode) {
        AbstractVector.AbstractBuilder result;
        if (mode.equals("any")) {
            if (x instanceof AtomicVector) {
                return x.setAttributes(AttributeMap.EMPTY);
            }
            return x;
        }
        if ("character".equals(mode)) {
            result = new StringVector.Builder();
        } else if ("logical".equals(mode)) {
            result = new LogicalArrayVector.Builder(x.length());
            Vectors.checkForListThatCannotBeCoercedToAtomicVector(x, mode);
        } else if ("integer".equals(mode)) {
            result = new IntArrayVector.Builder(x.length());
            Vectors.checkForListThatCannotBeCoercedToAtomicVector(x, mode);
        } else if ("raw".equals(mode)) {
            result = new RawVector.Builder();
            Vectors.checkForListThatCannotBeCoercedToAtomicVector(x, mode);
        } else if ("numeric".equals(mode) || "double".equals(mode)) {
            result = new DoubleArrayVector.Builder(x.length());
            Vectors.checkForListThatCannotBeCoercedToAtomicVector(x, mode);
        } else if ("complex".equals(mode)) {
            if (x instanceof DoubleVector) {
                return Vectors.doubleToComplex((DoubleVector)x);
            }
            result = new ComplexArrayVector.Builder(x.length());
            Vectors.checkForListThatCannotBeCoercedToAtomicVector(x, mode);
        } else if ("list".equals(mode)) {
            result = new ListVector.Builder();
            result.setAttribute(Symbols.NAMES, (SEXP)x.getNames());
        } else if ("expression".equals(mode)) {
            result = new ExpressionVector.Builder();
            if (x == Null.INSTANCE) {
                return new ExpressionVector(Null.INSTANCE);
            }
            if (x instanceof ListVector) {
                return new ExpressionVector(((ListVector)x).toArrayUnsafe(), x.getAttributes());
            }
        } else {
            if ("pairlist".equals(mode)) {
                return Vectors.asPairList(x);
            }
            if ("symbol".equals(mode)) {
                if (x.length() == 0) {
                    throw new EvalException("invalid type/length (symbol/0) in vector allocation", new Object[0]);
                }
                if (x instanceof ListVector) {
                    throw new EvalException("vector of type 'list' cannot be coerced to symbol", new Object[0]);
                }
                return Symbol.get(x.getElementAsString(0));
            }
            throw new EvalException("invalid 'mode' argument: " + mode, new Object[0]);
        }
        for (int i = 0; i != x.length(); ++i) {
            result.setFrom(i, x, i);
        }
        return result.build();
    }

    private static ComplexVector doubleToComplex(DoubleVector x) {
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(x.length());
        for (int i = 0; i < x.length(); ++i) {
            result.set(i, x.getElementAsDouble(i), 0.0);
        }
        return result.build();
    }

    private static void checkForListThatCannotBeCoercedToAtomicVector(Vector x, String mode) {
        if (x instanceof ListVector) {
            ListVector list2 = (ListVector)x;
            for (int i = 0; i < list2.length(); ++i) {
                SEXP element = list2.getElementAsSEXP(i);
                if (element != Null.INSTANCE && element.length() <= 1 && element instanceof Vector) continue;
                throw new EvalException("(list) object cannot be coerced to type '%s'", mode);
            }
        }
    }

    private static PairList asPairList(Vector x) {
        PairList.Builder builder = new PairList.Builder();
        for (int i = 0; i != x.length(); ++i) {
            builder.add(x.getName(i), (SEXP)x.getElementAsSEXP(i));
        }
        if (x instanceof ListVector) {
            for (Symbol attribute : x.getAttributes().names()) {
                if (attribute == Symbols.NAMES) continue;
                builder.setAttribute(attribute, x.getAttribute(attribute));
            }
        }
        return builder.build();
    }

    public static Predicate<SEXP> modePredicate(String mode) {
        if (mode.equals("any")) {
            return Predicates.alwaysTrue();
        }
        if (mode.equals("function")) {
            return CollectionUtils.IS_FUNCTION;
        }
        throw new EvalException(" mode '%s' as a predicate is not implemented.", mode);
    }

    @Internal
    public static SEXP vector(String mode, int length2) {
        if ("logical".equals(mode)) {
            return new LogicalArrayVector(new int[length2]);
        }
        if ("integer".equals(mode)) {
            return new IntArrayVector(new int[length2]);
        }
        if ("numeric".equals(mode) || "double".equals(mode)) {
            return RepDoubleVector.createConstantVector(0.0, length2);
        }
        if ("complex".equals(mode)) {
            throw new UnsupportedOperationException("implement me!");
        }
        if ("character".equals(mode)) {
            Object[] values = new String[length2];
            Arrays.fill(values, "");
            return new StringArrayVector((String[])values);
        }
        if ("list".equals(mode)) {
            Object[] values = new SEXP[length2];
            Arrays.fill(values, Null.INSTANCE);
            return new ListVector((SEXP[])values);
        }
        if ("pairlist".equals(mode)) {
            Object[] values = new SEXP[length2];
            Arrays.fill(values, Null.INSTANCE);
            return PairList.Node.fromArray((SEXP[])values);
        }
        if ("raw".equals(mode)) {
            byte[] values = new byte[length2];
            return new RawVector(values);
        }
        throw new EvalException(String.format("vector: cannot make a vector of mode '%s'.", mode), new Object[0]);
    }

    @Internal
    public static ComplexVector complex(int lengthOut, AtomicVector realVector, AtomicVector imaginaryVector) {
        if (realVector.length() > lengthOut) {
            lengthOut = realVector.length();
        }
        if (imaginaryVector.length() > lengthOut) {
            lengthOut = imaginaryVector.length();
        }
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(0, lengthOut);
        for (int i = 0; i != lengthOut; ++i) {
            double real2 = 0.0;
            double imaginary = 0.0;
            if (realVector.length() > 0) {
                real2 = realVector.getElementAsDouble(i % realVector.length());
            }
            if (imaginaryVector.length() > 0) {
                imaginary = imaginaryVector.getElementAsDouble(i % imaginaryVector.length());
            }
            result.add(ComplexVector.complex(real2, imaginary));
        }
        return result.build();
    }

    @Builtin
    public static ListVector list(@ArgumentList ListVector arguments) {
        return arguments;
    }

    @Internal
    public static SEXP drop(Vector x) {
        Vector dim2 = (Vector)x.getAttribute(Symbols.DIM);
        if (dim2.length() == 0) {
            return x;
        }
        Vector dimnames2 = (Vector)x.getAttribute(Symbols.DIMNAMES);
        IntArrayVector.Builder newDim = new IntArrayVector.Builder();
        ListVector.Builder newDimnames = new ListVector.Builder();
        boolean haveDimNames = false;
        for (int i = 0; i != dim2.length(); ++i) {
            if (dim2.getElementAsInt(i) <= 1) continue;
            newDim.add(dim2.getElementAsInt(i));
            if (dimnames2 == Null.INSTANCE) continue;
            Vector dimNameElement = (Vector)dimnames2.getElementAsSEXP(i);
            if (dimNameElement != Null.INSTANCE) {
                haveDimNames = true;
            }
            newDimnames.add(dimNameElement);
        }
        AttributeMap.Builder newAttributes = x.getAttributes().copy();
        if (newDim.length() == 0 || newDim.length() == 1 && dim2.length() > 1) {
            newAttributes.remove(Symbols.DIM);
            newAttributes.remove(Symbols.DIMNAMES);
        } else {
            newAttributes.setDim(newDim.build());
            newAttributes.setDimNames(newDimnames.build());
        }
        return x.setAttributes(newAttributes);
    }

    public static AtomicVector toType(AtomicVector x, Vector.Type type) {
        if (x.getVectorType() == type) {
            return x;
        }
        if (type == DoubleVector.VECTOR_TYPE) {
            return Vectors.asDouble(x);
        }
        if (type == IntVector.VECTOR_TYPE) {
            return Vectors.asInteger(x);
        }
        if (type == LogicalVector.VECTOR_TYPE) {
            return Vectors.asLogical(x);
        }
        if (type == ComplexVector.VECTOR_TYPE) {
            return Vectors.asComplex(x);
        }
        if (type == StringVector.VECTOR_TYPE) {
            return new ConvertingStringVector(x);
        }
        if (type == RawVector.VECTOR_TYPE) {
            return Vectors.asRaw(x);
        }
        throw new IllegalArgumentException("type: " + type);
    }

    @Generic
    @Internal(value="as.vector")
    public static SEXP asVector(Symbol x, String mode) {
        if ("character".equals(mode)) {
            return StringVector.valueOf(x.getPrintName());
        }
        if ("list".equals(mode)) {
            return new ListVector(x);
        }
        if ("expression".equals(mode)) {
            return new ExpressionVector(x);
        }
        if ("symbol".equals(mode)) {
            return x;
        }
        throw new EvalException("'%s' cannot be coerced to vector of type '%s'", x.getTypeName(), mode);
    }

    @Generic
    @Internal(value="as.vector")
    public static SEXP asVector(@Current Context context, PairList x, String mode) {
        AbstractVector.AbstractBuilder result;
        if ("pairlist".equals(mode) || "any".equals(mode)) {
            return x;
        }
        if ("list".equals(mode)) {
            return x.toVector();
        }
        if ("expression".equals(mode)) {
            return new ExpressionVector(x);
        }
        if ("character".equals(mode)) {
            result = new StringVector.Builder(0, x.length());
        } else if ("logical".equals(mode)) {
            result = new LogicalArrayVector.Builder(0, x.length());
        } else if ("numeric".equals(mode) || "double".equals(mode)) {
            result = new DoubleArrayVector.Builder(0, x.length());
        } else if ("complex".equals(mode)) {
            result = new ComplexArrayVector.Builder(0, x.length());
        } else if ("integer".equals(mode)) {
            result = new IntArrayVector.Builder(0, x.length());
        } else if ("list".equals(mode)) {
            result = new ListVector.Builder();
        } else if ("raw".equals(mode)) {
            result = new RawVector.Builder();
        } else {
            throw new EvalException("invalid 'mode' argument", new Object[0]);
        }
        for (PairList.Node node : x.nodes()) {
            if (node.getValue() instanceof AtomicVector && node.getValue() != Null.INSTANCE) {
                result.add(node.getValue());
                continue;
            }
            if (result instanceof StringVector.Builder) {
                ((StringVector.Builder)result).add(Deparse.deparseExp(context, node.getValue()));
                continue;
            }
            throw new EvalException("'%s' cannot be coerced to type '%s'", x.getTypeName(), mode);
        }
        return result.build();
    }

    @Internal
    public static StringVector rawToChar(RawVector vector2, boolean multiple) {
        byte[] bytes = vector2.toByteArray();
        if (multiple) {
            StringVector.Builder result = new StringVector.Builder(0, vector2.length());
            for (int i = 0; i != vector2.length(); ++i) {
                result.add(StringVector.valueOf(new String(bytes, i, 1)));
            }
            return result.build();
        }
        return StringVector.valueOf(new String(bytes));
    }

    @Internal
    public static RawVector rawToBits(RawVector vector2) {
        RawVector.Builder bits = new RawVector.Builder();
        for (int i = 0; i != vector2.length(); ++i) {
            int intValue = vector2.getElementAsInt(i);
            for (int bit = 0; bit != 8; ++bit) {
                int mask = 1 << bit;
                if ((intValue & mask) != 0) {
                    bits.add(1);
                    continue;
                }
                bits.add(0);
            }
        }
        return bits.build();
    }

    @Internal
    public static RawVector charToRaw(StringVector sv) {
        if (sv.length() != 1) {
            throw new EvalException("argument should be a character vector of length 1", new Object[0]);
        }
        return new RawVector(sv.getElementAsString(0).getBytes(Charsets.UTF_8));
    }

    @Internal
    public static RawVector rawShift(RawVector rv, int n) {
        if (n > RawVector.NUM_BITS || n < -1 * RawVector.NUM_BITS) {
            throw new EvalException("argument 'shift' must be a small integer", new Object[0]);
        }
        RawVector.Builder b = new RawVector.Builder();
        for (int i = 0; i < rv.length(); ++i) {
            int r = n >= 0 ? rv.getElementAsByte(i) << Math.abs(n) : rv.getElementAsByte(i) >> Math.abs(n);
            b.add(r);
        }
        return b.build();
    }

    @Internal
    public static RawVector intToBits(Vector vector2) {
        RawVector.Builder bits = new RawVector.Builder();
        for (int i = 0; i != vector2.length(); ++i) {
            int intValue = vector2.getElementAsInt(i);
            for (int bit = 0; bit != 32; ++bit) {
                int mask = 1 << bit;
                if ((intValue & mask) != 0) {
                    bits.add(1);
                    continue;
                }
                bits.add(0);
            }
        }
        return bits.build();
    }
}

