/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class WriteTextConnection
implements Connection {
    private Symbol objectName;
    private Environment environment;
    private boolean open = true;
    private PrintWriter printWriter;

    public WriteTextConnection(Symbol objectName, Environment environment2) {
        this.objectName = objectName;
        this.environment = environment2;
        this.printWriter = new PrintWriter(new Writer(){
            private List<String> lines = new ArrayList<String>();
            private StringBuilder buffer = new StringBuilder();

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                int pos = off;
                for (int remaining = len; remaining > 0; --remaining) {
                    if (cbuf[pos] == '\n') {
                        this.lines.add(this.buffer.toString());
                        this.buffer.setLength(0);
                    } else {
                        this.buffer.append(cbuf[pos]);
                    }
                    ++pos;
                }
            }

            @Override
            public void flush() throws IOException {
                if (this.buffer.length() > 0) {
                    this.lines.add(this.buffer.toString());
                    this.buffer.setLength(0);
                }
                if (this.lines.size() > 0) {
                    WriteTextConnection.this.appendLines(this.lines);
                    this.lines.clear();
                }
            }

            @Override
            public void close() throws IOException {
            }
        });
    }

    private void appendLines(List<String> lines) {
        SEXP output = this.environment.getVariableUnsafe(this.objectName);
        if (output == Symbol.UNBOUND_VALUE) {
            output = new StringArrayVector((Collection<String>)lines);
        } else if (output instanceof StringVector) {
            StringVector.Builder builder = ((StringVector)output).newCopyBuilder();
            builder.addAll(lines);
            output = builder.build();
        } else {
            throw new UnsupportedOperationException();
        }
        this.environment.setVariableUnsafe(this.objectName, output);
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
        this.environment.setVariableUnsafe(this.objectName, (SEXP)StringVector.EMPTY);
        this.environment.lockBinding(this.objectName);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public PrintWriter getPrintWriter() throws IOException {
        return this.printWriter;
    }

    @Override
    public PrintWriter getOpenPrintWriter() {
        return this.printWriter;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.environment.unlockBinding(this.objectName);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public String getClassName() {
        return "textConnection";
    }

    @Override
    public String getDescription() {
        return this.objectName.getPrintName();
    }

    @Override
    public String getMode() {
        return "w";
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.TEXT;
    }
}

