/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.match;

import java.util.HashMap;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Contexts;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.primitives.vector.ConvertingStringVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Match {
    private static final int UNMATCHED = -1;
    private static final int MULTIPLE_MATCH = -2;

    private Match() {
    }

    @Internal
    public static IntVector match(Vector search2, Vector table, int noMatch, AtomicVector incomparables) {
        IntSequence sequence;
        if (incomparables.equals(LogicalVector.FALSE)) {
            incomparables = Null.INSTANCE;
        }
        if (search2 instanceof StringVector || table instanceof StringVector) {
            if (search2.inherits("factor")) {
                search2 = new FactorString(search2);
            }
            if (table.inherits("factor")) {
                table = new FactorString(table);
            }
        }
        if ((sequence = Match.isStringSequence(table)) != null && sequence.getBy() == 1 && incomparables.length() == 0) {
            return Match.matchAgainstStringSequence(search2, sequence, noMatch);
        }
        Vector.Type commonType = Vector.Type.widest(search2.getVectorType(), table.getVectorType());
        search2 = commonType.to(search2);
        table = commonType.to(table);
        int[] matches = new int[search2.length()];
        for (int i = 0; i != search2.length(); ++i) {
            if (incomparables.contains(search2, i)) {
                matches[i] = noMatch;
                continue;
            }
            int pos = search2.isElementNA(i) ? Match.indexOfNA(table) : table.indexOf(search2, i, 0);
            matches[i] = pos >= 0 ? pos + 1 : noMatch;
        }
        return IntArrayVector.unsafe(matches);
    }

    private static IntVector matchAgainstStringSequence(Vector search2, IntSequence sequence, int noMatch) {
        assert (sequence.getBy() == 1);
        int from = sequence.getFrom();
        int length2 = sequence.length();
        int[] matches = new int[search2.length()];
        boolean identity = search2.length() == sequence.length();
        for (int i = 0; i != search2.length(); ++i) {
            String toMatch = search2.getElementAsString(i);
            if (toMatch == null) {
                matches[i] = noMatch;
                identity = false;
                continue;
            }
            try {
                int index = Integer.parseInt(toMatch) - from + 1;
                if (index > length2) {
                    matches[i] = noMatch;
                    identity = false;
                    continue;
                }
                matches[i] = index;
                if (index == i + 1) continue;
                identity = false;
                continue;
            }
            catch (NumberFormatException ignored) {
                matches[i] = noMatch;
                identity = false;
            }
        }
        if (identity) {
            return new IntSequence(1, 1, search2.length());
        }
        return IntArrayVector.unsafe(matches);
    }

    private static IntSequence isStringSequence(Vector table) {
        ConvertingStringVector wrapper;
        if (table instanceof ConvertingStringVector && (wrapper = (ConvertingStringVector)table).getOperand() instanceof IntSequence) {
            return (IntSequence)wrapper.getOperand();
        }
        return null;
    }

    private static IntVector matchUsingStringHash(Vector search2, Vector table, int noMatch, AtomicVector incomparables) {
        int i;
        HashMap<String, Integer> lookup = new HashMap<String, Integer>();
        for (i = 0; i < table.length(); ++i) {
            String tableElement = table.getElementAsString(i);
            if (lookup.containsKey(tableElement)) continue;
            lookup.put(tableElement, i);
        }
        for (i = 0; i < incomparables.length(); ++i) {
            lookup.put(incomparables.getElementAsString(i), noMatch);
        }
        int[] match2 = new int[search2.length()];
        for (int i2 = 0; i2 < search2.length(); ++i2) {
            String toMatch = search2.getElementAsString(i2);
            Integer index = (Integer)lookup.get(toMatch);
            match2[i2] = index == null ? noMatch : index;
        }
        return new IntArrayVector(match2);
    }

    private static int indexOfNA(Vector table) {
        for (int i = 0; i != table.length(); ++i) {
            if (!table.isElementNA(i)) continue;
            return i;
        }
        return -1;
    }

    @Internal
    public static IntVector pmatch(StringVector x, StringVector table, int noMatch, boolean duplicatesOk) {
        return Match.commonStringMatch(x, table, noMatch, noMatch, duplicatesOk);
    }

    @Internal
    public static IntVector charmatch(StringVector x, StringVector table, int noMatch) {
        return Match.commonStringMatch(x, table, noMatch, 0, true);
    }

    private static IntVector commonStringMatch(StringVector x, StringVector table, int unmatchedCode, int duplicatePartialsCode, boolean duplicatesOk) {
        int match2;
        String toMatch;
        int i;
        IntArrayVector.Builder result = new IntArrayVector.Builder(x.length());
        boolean[] matchedTable = new boolean[table.length()];
        boolean[] matchedSearch = new boolean[x.length()];
        for (i = 0; i != x.length(); ++i) {
            toMatch = Match.pmatchElementAt(x, i);
            match2 = Match.exactMatch(toMatch, table);
            if (match2 == -1 || !duplicatesOk && matchedTable[match2]) continue;
            result.set(i, match2 + 1);
            matchedTable[match2] = true;
            matchedSearch[i] = true;
        }
        for (i = 0; i != x.length(); ++i) {
            if (matchedSearch[i]) continue;
            toMatch = Match.pmatchElementAt(x, i);
            match2 = Match.uniquePartialMatch(toMatch, table);
            if (match2 == -1) {
                result.set(i, unmatchedCode);
                continue;
            }
            if (match2 == -2) {
                result.set(i, duplicatePartialsCode);
                continue;
            }
            if (!duplicatesOk && matchedTable[match2]) continue;
            result.set(i, match2 + 1);
            matchedTable[match2] = true;
        }
        return result.build();
    }

    private static int exactMatch(String toMatch, StringVector table) {
        for (int i = 0; i != table.length(); ++i) {
            String t2 = Match.pmatchElementAt(table, i);
            if (!toMatch.equals(t2)) continue;
            return i;
        }
        return -1;
    }

    private static int uniquePartialMatch(String toMatch, StringVector table) {
        int partialMatch = -1;
        for (int i = 0; i != table.length(); ++i) {
            String t2 = Match.pmatchElementAt(table, i);
            if (!t2.startsWith(toMatch)) continue;
            if (partialMatch != -1) {
                return -2;
            }
            partialMatch = i;
        }
        return partialMatch;
    }

    private static String pmatchElementAt(StringVector vector2, int i) {
        return vector2.isElementNA(i) ? "NA" : vector2.getElementAsString(i);
    }

    @Internal(value="match.call")
    public static SEXP matchCall(@Current Context context, @Current Environment rho, SEXP definition, FunctionCall call2, boolean expandDots, SEXP environment2) {
        Closure closure = null;
        if (definition instanceof Closure) {
            closure = (Closure)definition;
        } else if (definition == Null.INSTANCE) {
            Context parentContext = Contexts.findCallingContext(context);
            if (parentContext.getFunction() instanceof Closure) {
                closure = (Closure)parentContext.getFunction();
            }
            if (closure == null) {
                throw new EvalException("match.call() was called from outside a function", new Object[0]);
            }
        } else {
            throw new EvalException("match.call cannot use definition of type '%s'", definition.getTypeName());
        }
        PairList matched = ClosureDispatcher.matchArguments(closure.getFormals(), call2.getArguments(), true);
        PairList.Builder expandedArgs = new PairList.Builder();
        for (PairList.Node node : matched.nodes()) {
            if (node.getValue() == Symbol.MISSING_ARG) continue;
            if (expandDots && node.getTag() == Symbols.ELLIPSES) {
                for (PairList.Node elipseNode : ((PairList)node.getValue()).nodes()) {
                    expandedArgs.add(elipseNode.getRawTag(), elipseNode.getValue());
                }
                continue;
            }
            expandedArgs.add(node.getTag(), node.getValue());
        }
        return new FunctionCall(call2.getFunction(), expandedArgs.build());
    }

    @Internal
    public static IntVector which(Vector x) {
        IntArrayVector.Builder indices = new IntArrayVector.Builder();
        AtomicVector xn = x.getNames();
        StringVector.Builder names2 = null;
        if (xn != Null.INSTANCE) {
            names2 = new StringVector.Builder();
        }
        for (int i = 0; i != x.length(); ++i) {
            if (!x.isElementTrue(i)) continue;
            indices.add(i + 1);
            if (names2 == null) continue;
            names2.add(xn.getElementAsString(i));
        }
        if (names2 != null) {
            indices.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        }
        return indices.build();
    }

    private static class FactorString
    extends StringVector {
        private final Vector factor;
        private final Vector levels;

        private FactorString(Vector factor) {
            super(AttributeMap.EMPTY);
            this.factor = factor;
            this.levels = (Vector)factor.getAttribute(Symbols.LEVELS);
        }

        @Override
        public int length() {
            return this.factor.length();
        }

        @Override
        protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementAsString(int index) {
            if (this.factor.isElementNA(index)) {
                return StringVector.NA;
            }
            int level = this.factor.getElementAsInt(index);
            return this.levels.getElementAsString(level - 1);
        }

        @Override
        public boolean isConstantAccessTime() {
            return true;
        }
    }
}

