/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.ni;

import java.lang.invoke.MethodHandle;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.primitives.ni.DeferredNativeCall;
import org.renjin.primitives.ni.NativeOutputBoolVector;
import org.renjin.primitives.ni.NativeOutputDoubleVector;
import org.renjin.primitives.ni.NativeOutputIntVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DeferredFortranCall
implements DeferredNativeCall {
    private String methodName;
    private final MethodHandle method;
    private final Class<?>[] parameterType;
    private final Vector[] operands;
    private final Object[] outputArrays;
    private final ListVector outputList;
    private boolean inputsDeferred = false;
    private boolean evaluated = false;

    public DeferredFortranCall(String methodName, MethodHandle method, ListVector inputs) {
        this.methodName = methodName;
        this.method = method;
        this.parameterType = method.type().parameterArray();
        if (this.parameterType.length != inputs.length()) {
            throw new EvalException("Invalid number of args", new Object[0]);
        }
        this.operands = new Vector[inputs.length()];
        this.outputArrays = new Object[inputs.length()];
        ListVector.NamedBuilder outputList = new ListVector.NamedBuilder();
        for (int i = 0; i != inputs.length(); ++i) {
            AtomicVector vector2 = (AtomicVector)inputs.get(i);
            this.operands[i] = vector2;
            if (vector2.isDeferred()) {
                this.inputsDeferred = true;
            }
            if (this.parameterType[i].equals(DoublePtr.class)) {
                outputList.add(inputs.getName(i), (SEXP)new NativeOutputDoubleVector(this, i, vector2.length(), vector2.getAttributes()));
                continue;
            }
            if (this.parameterType[i].equals(IntPtr.class)) {
                outputList.add(inputs.getName(i), (SEXP)new NativeOutputIntVector(this, i, vector2.length(), vector2.getAttributes()));
                continue;
            }
            if (this.parameterType[i].equals(BooleanPtr.class)) {
                outputList.add(inputs.getName(i), (SEXP)new NativeOutputBoolVector(this, i, vector2.length(), vector2.getAttributes()));
                continue;
            }
            throw new UnsupportedOperationException("fortran type: " + this.parameterType[i]);
        }
        this.outputList = outputList.build();
    }

    @Override
    public Vector[] getOperands() {
        return this.operands;
    }

    @Override
    public String getOutputName(int outputIndex) {
        return this.outputList.getNames().getElementAsString(outputIndex);
    }

    @Override
    public boolean isEvaluated() {
        return this.evaluated;
    }

    @Override
    public Object output(int outputIndex) {
        if (!this.evaluated) {
            throw new IllegalStateException("Not evaluated yet.");
        }
        return this.outputArrays[outputIndex];
    }

    @Override
    public String getDebugName() {
        return this.methodName;
    }

    public ListVector getOutputList() {
        return this.outputList;
    }

    @Override
    public void evaluate(Vector[] operands) {
        for (int i = 0; i < operands.length; ++i) {
            AtomicVector inputVector = (AtomicVector)operands[i];
            if (this.parameterType[i].equals(DoublePtr.class)) {
                this.outputArrays[i] = inputVector.toDoubleArray();
                continue;
            }
            if (this.parameterType[i].equals(IntPtr.class)) {
                this.outputArrays[i] = inputVector.toIntArray();
                continue;
            }
            if (this.parameterType[i].equals(BooleanPtr.class)) {
                this.outputArrays[i] = DeferredFortranCall.toBooleanArray(inputVector);
                continue;
            }
            throw new UnsupportedOperationException("parameterType: " + this.parameterType);
        }
        this.invoke();
    }

    private static boolean[] toBooleanArray(AtomicVector vector2) {
        boolean[] array2 = new boolean[vector2.length()];
        for (int i = 0; i < vector2.length(); ++i) {
            int element = vector2.getElementAsRawLogical(i);
            if (element == Integer.MIN_VALUE) {
                throw new EvalException("NAs cannot be passed to logical fortran argument", new Object[0]);
            }
            array2[i] = element != 0;
        }
        return array2;
    }

    private void invoke() {
        Object[] fortranArgs = new Object[this.operands.length];
        for (int i = 0; i < this.operands.length; ++i) {
            if (this.parameterType[i].equals(DoublePtr.class)) {
                fortranArgs[i] = new DoublePtr((double[])this.outputArrays[i]);
                continue;
            }
            if (this.parameterType[i].equals(IntPtr.class)) {
                fortranArgs[i] = new IntPtr((int[])this.outputArrays[i]);
                continue;
            }
            if (this.parameterType[i].equals(BooleanPtr.class)) {
                fortranArgs[i] = new BooleanPtr((boolean[])this.outputArrays[i]);
                continue;
            }
            throw new UnsupportedOperationException("parameterType: " + this.parameterType[i]);
        }
        try {
            this.method.invokeWithArguments(fortranArgs);
            this.evaluated = true;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception thrown while executing " + this.method, e);
        }
    }
}

