/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Native;
import org.renjin.primitives.packaging.DllSymbol;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class DllInfo {
    private final String libraryName;
    private final Class libraryClass;
    private final Map<String, DllSymbol> registeredSymbols = new HashMap<String, DllSymbol>();
    private boolean useDynamicSymbols = true;
    private boolean forceSymbols = false;

    public DllInfo(String libraryName, Class clazz) {
        this.libraryName = libraryName;
        this.libraryClass = clazz;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void register(DllSymbol symbol2) {
        this.registeredSymbols.put(symbol2.getName(), symbol2);
    }

    public boolean setUseDynamicSymbols(boolean use) {
        boolean oldValue = this.useDynamicSymbols;
        this.useDynamicSymbols = use;
        return oldValue;
    }

    public boolean forceSymbols(boolean value) {
        boolean oldValue = this.forceSymbols;
        this.forceSymbols = value;
        return oldValue;
    }

    public Optional<DllSymbol> getRegisteredSymbol(String name) {
        return Optional.fromNullable(this.registeredSymbols.get(name));
    }

    public Iterable<DllSymbol> getRegisteredSymbols() {
        return this.registeredSymbols.values();
    }

    public void initialize(Context context) {
        Optional<Method> initMethod = this.findInitRoutine();
        if (initMethod.isPresent()) {
            Context previousContext = Native.CURRENT_CONTEXT.get();
            Native.CURRENT_CONTEXT.set(context);
            try {
                if (initMethod.get().getParameterTypes().length == 0) {
                    initMethod.get().invoke(null, new Object[0]);
                } else {
                    initMethod.get().invoke(null, this);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new EvalException("Exception initializing compiled GNU R library " + this.libraryClass, e.getCause());
            }
            finally {
                Native.CURRENT_CONTEXT.set(previousContext);
            }
        }
    }

    private Optional<Method> findInitRoutine() {
        String initName = "R_init_" + this.sanitizeLibraryName(this.libraryName);
        Object[] expectedParameterTypes = new Class[]{DllInfo.class};
        for (Method method : this.libraryClass.getMethods()) {
            if (!method.getName().equals(initName)) continue;
            if (method.getParameterTypes().length != 0 && !Arrays.equals(method.getParameterTypes(), expectedParameterTypes)) {
                throw new EvalException(String.format("%s.%s has invalid signature: %s. Expected %s(DllInfo info)", this.libraryClass.getName(), initName, method.toString(), initName), new Object[0]);
            }
            return Optional.of(method);
        }
        return Optional.absent();
    }

    private String sanitizeLibraryName(String libraryName) {
        return libraryName.replace('.', '_');
    }

    private boolean isPublicStatic(Method method) {
        return Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }

    public Optional<DllSymbol> lookup(DllSymbol.Convention convention, String symbolName) {
        if (this.forceSymbols) {
            return Optional.absent();
        }
        Optional<DllSymbol> registeredSymbol = this.lookupRegisteredSymbol(convention, symbolName);
        if (registeredSymbol.isPresent()) {
            return registeredSymbol;
        }
        if (this.useDynamicSymbols) {
            return this.lookupWithReflection(convention, symbolName);
        }
        return Optional.absent();
    }

    private Optional<DllSymbol> lookupRegisteredSymbol(DllSymbol.Convention convention, String symbolName) {
        if (convention == DllSymbol.Convention.FORTRAN) {
            symbolName = symbolName.toLowerCase();
        }
        return Optional.fromNullable(this.registeredSymbols.get(symbolName));
    }

    private Optional<DllSymbol> lookupWithReflection(DllSymbol.Convention convention, String symbolName) {
        if (convention == DllSymbol.Convention.FORTRAN) {
            symbolName = symbolName.toLowerCase() + "_";
        }
        for (Method method : this.libraryClass.getMethods()) {
            if (!method.getName().equals(symbolName) || !this.isPublicStatic(method)) continue;
            return Optional.of(new DllSymbol(method));
        }
        return Optional.absent();
    }

    public SEXP buildDllInfoSexp() {
        ListVector.NamedBuilder object2 = ListVector.newNamedBuilder();
        object2.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("DLLInfo"));
        object2.add("name", this.libraryName);
        object2.add("path", this.libraryClass.getName());
        object2.add("dynamicLookup", this.useDynamicSymbols);
        object2.add("info", new ExternalPtr<DllInfo>(this));
        return object2.build();
    }

    public ListVector buildRegisteredRoutinesSexp() {
        ListVector.NamedBuilder object2 = new ListVector.NamedBuilder();
        object2.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("DLLRegisteredRoutines"));
        object2.add(".C", (SEXP)this.buildNativeRoutineList(DllSymbol.Convention.C));
        object2.add(".Call", (SEXP)this.buildNativeRoutineList(DllSymbol.Convention.CALL));
        object2.add(".Fortran", (SEXP)this.buildNativeRoutineList(DllSymbol.Convention.FORTRAN));
        object2.add(".External", (SEXP)this.buildNativeRoutineList(DllSymbol.Convention.EXTERNAL));
        return object2.build();
    }

    private ListVector buildNativeRoutineList(DllSymbol.Convention convention) {
        ListVector.NamedBuilder object2 = new ListVector.NamedBuilder();
        object2.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("NativeRoutineList"));
        for (DllSymbol symbol2 : this.registeredSymbols.values()) {
            if (symbol2.getConvention() != convention) continue;
            object2.add(symbol2.getName(), (SEXP)symbol2.buildNativeSymbolInfoSexp());
        }
        return object2.build();
    }
}

