/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.ClassBindingImpl;
import org.renjin.methods.S4;
import org.renjin.primitives.S3;
import org.renjin.primitives.packaging.DllInfo;
import org.renjin.primitives.packaging.DllSymbol;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.NamespaceFile;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.primitives.packaging.Package;
import org.renjin.primitives.text.regex.RE;
import org.renjin.primitives.text.regex.REFactory;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Function;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class Namespace {
    private final Package pkg;
    private final Environment namespaceEnvironment;
    private final Environment importsEnvironment;
    private final Environment baseNamespaceEnvironment;
    private final List<Symbol> exports = Lists.newArrayList();
    protected final List<DllInfo> libraries = new ArrayList<DllInfo>(0);
    boolean loaded;

    public Namespace(Package pkg, Environment namespaceEnvironment) {
        this.pkg = pkg;
        this.namespaceEnvironment = namespaceEnvironment;
        this.importsEnvironment = namespaceEnvironment.getParent();
        this.baseNamespaceEnvironment = this.importsEnvironment.getParent();
    }

    public String getName() {
        return this.pkg.getName().getPackageName();
    }

    public FqPackageName getFullyQualifiedName() {
        return this.pkg.getName();
    }

    public String getCompatibleName() {
        if (this.pkg.getName().getGroupId().equals("org.renjin")) {
            return this.pkg.getName().getPackageName();
        }
        return this.pkg.getName().toString(':');
    }

    public Collection<Symbol> getExports() {
        if (FqPackageName.BASE.equals(this.pkg.getName())) {
            return this.namespaceEnvironment.getSymbolNames();
        }
        return Collections.unmodifiableCollection(this.exports);
    }

    public SEXP getEntry(Symbol entry) {
        SEXP value = this.namespaceEnvironment.getVariableUnsafe(entry);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Namespace " + this.pkg.getName() + " has no symbol named '" + entry + "'", new Object[0]);
        }
        return value;
    }

    public SEXP getExport(Symbol entry) {
        SEXP value = this.getExportIfExists(entry);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Namespace " + this.pkg.getName() + " has no exported symbol named '" + entry.getPrintName() + "'", new Object[0]);
        }
        return value;
    }

    public SEXP getExportIfExists(Symbol entry) {
        if (FqPackageName.BASE.equals(this.pkg.getName())) {
            return this.namespaceEnvironment.getVariableUnsafe(entry);
        }
        if (this.exports.contains(entry)) {
            return this.namespaceEnvironment.findVariableUnsafe(entry);
        }
        return Symbol.UNBOUND_VALUE;
    }

    public Environment getImportsEnvironment() {
        return this.importsEnvironment;
    }

    public Environment getNamespaceEnvironment() {
        return this.namespaceEnvironment;
    }

    public List<DllInfo> getLibraries() {
        return this.libraries;
    }

    public void copyExportsTo(Context context, Environment packageEnv) {
        for (Symbol name : this.exports) {
            SEXP exportValue = this.namespaceEnvironment.findVariableUnsafe(name);
            if (exportValue == Symbol.UNBOUND_VALUE) {
                context.warn(String.format("Symbol '%s' is not defined in package '%s'", name.getPrintName(), this.pkg.getName()));
                continue;
            }
            packageEnv.setVariableUnsafe(name, exportValue);
        }
    }

    public void addExport(Symbol export) {
        this.exports.add(export);
    }

    public Package getPackage() {
        return this.pkg;
    }

    public static String sanitizePackageNameForClassFiles(String packageName) {
        return packageName.replace('.', '$');
    }

    public void initImports(Context context, NamespaceRegistry registry, NamespaceFile file2) {
        for (NamespaceFile.PackageImportEntry packageImportEntry : file2.getPackageImports()) {
            Namespace importedNamespace = registry.getNamespace(context, packageImportEntry.getPackageName());
            if (packageImportEntry.isAllSymbols()) {
                importedNamespace.copyExportsTo(context, this.importsEnvironment);
                continue;
            }
            for (Symbol symbol2 : packageImportEntry.getSymbols()) {
                SEXP export = importedNamespace.getExportIfExists(symbol2);
                if (export == Symbol.UNBOUND_VALUE) {
                    context.warn(String.format("Symbol '%s' not exported from namespace '%s'", symbol2.getPrintName(), importedNamespace.getName()));
                    continue;
                }
                this.importsEnvironment.setVariableUnsafe(symbol2, export);
            }
            for (String className : packageImportEntry.getClasses()) {
                Symbol symbol3 = S4.classNameMetadata(className);
                SEXP export = importedNamespace.getExportIfExists(symbol3);
                if (export == Symbol.UNBOUND_VALUE) {
                    context.warn(String.format("Class '%s' is not exported from namespace '%s'", className, importedNamespace.getName()));
                    continue;
                }
                this.importsEnvironment.setVariableUnsafe(symbol3, export);
            }
        }
        for (NamespaceFile.JvmClassImportEntry jvmClassImportEntry : file2.getJvmImports()) {
            Class importedClass = null;
            try {
                importedClass = this.pkg.loadClass(jvmClassImportEntry.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new EvalException("Could not load JVM class '%s' from package '%s'", jvmClassImportEntry.getClassName(), this.pkg.getName());
            }
            if (jvmClassImportEntry.isClassImported()) {
                this.importsEnvironment.setVariableUnsafe(importedClass.getSimpleName(), new ExternalPtr<Class>(importedClass));
            }
            if (jvmClassImportEntry.getMethods().isEmpty()) continue;
            ClassBindingImpl importedClassBinding = ClassBindingImpl.get(importedClass);
            for (String method : jvmClassImportEntry.getMethods()) {
                this.importsEnvironment.setVariableUnsafe(method, importedClassBinding.getStaticMember(method).getValue());
            }
        }
        for (NamespaceFile.DynLibEntry dynLibEntry : file2.getDynLibEntries()) {
            this.importDynamicLibrary(context, dynLibEntry);
        }
    }

    private void importDynamicLibrary(Context context, NamespaceFile.DynLibEntry entry) {
        DllInfo library2;
        try {
            library2 = this.loadDynamicLibrary(context, entry.getLibraryName());
        }
        catch (Exception e) {
            e.printStackTrace();
            context.warn("Could not load compiled Fortran/C/C++ sources class for package " + this.pkg.getName() + ".\n" + "This is most likely because Renjin's compiler is not yet able to handle the sources for this\n" + "particular package. As a result, some functions may not work.\n");
            e.printStackTrace();
            return;
        }
        for (NamespaceFile.DynLibSymbol declaredSymbol : entry.getSymbols()) {
            Optional<DllSymbol> symbol2 = library2.lookup(DllSymbol.Convention.C, declaredSymbol.getSymbolName());
            if (!symbol2.isPresent()) continue;
            this.namespaceEnvironment.setVariableUnsafe(entry.getPrefix() + declaredSymbol.getAlias(), (SEXP)symbol2.get().buildNativeSymbolInfoSexp());
        }
        if (entry.isRegistration()) {
            for (DllSymbol symbol3 : library2.getRegisteredSymbols()) {
                this.namespaceEnvironment.setVariableUnsafe(entry.getPrefix() + symbol3.getName(), (SEXP)symbol3.buildNativeSymbolInfoSexp());
            }
        }
    }

    public DllInfo loadDynamicLibrary(Context context, String libraryName) throws ClassNotFoundException {
        FqPackageName packageName = this.pkg.getName();
        String className = packageName.getGroupId() + "." + Namespace.sanitizePackageNameForClassFiles(packageName.getPackageName()) + "." + Namespace.sanitizePackageNameForClassFiles(libraryName);
        Class libraryClass = this.pkg.loadClass(className);
        DllInfo library2 = new DllInfo(libraryName, libraryClass);
        library2.initialize(context);
        context.getSession().loadLibrary(library2);
        this.libraries.add(library2);
        return library2;
    }

    public Optional<DllSymbol> lookupSymbol(DllSymbol.Convention convention, String name) {
        for (DllInfo library2 : this.libraries) {
            Optional<DllSymbol> symbol2 = library2.lookup(convention, name);
            if (!symbol2.isPresent()) continue;
            return symbol2;
        }
        return Optional.absent();
    }

    public void initExports(NamespaceFile file2) {
        for (String pattern : file2.getExportedPatterns()) {
            RE re = REFactory.compile(pattern, false, false, false, false);
            for (Symbol symbol2 : this.namespaceEnvironment.getSymbolNames()) {
                if (!re.match(symbol2.getPrintName())) continue;
                this.exports.add(symbol2);
            }
        }
        for (Symbol symbol3 : file2.getExportedSymbols()) {
            this.exports.add(symbol3);
        }
        for (String className : file2.getExportedClasses()) {
            this.exports.add(S4.classNameMetadata(className));
        }
        for (String methodName : file2.getExportedS4Methods()) {
            this.exports.add(Symbol.get(methodName));
        }
    }

    public void registerS3Methods(Context context, NamespaceFile file2) {
        for (NamespaceFile.S3MethodEntry entry : file2.getExportedS3Methods()) {
            this.registerS3Method(context, entry);
        }
    }

    private void registerS3Method(Context context, NamespaceFile.S3MethodEntry entry) {
        Function method = this.resolveFunction(context, entry.getFunctionName());
        Optional<Environment> definitionEnv = this.resolveGenericFunctionNamespace(context, entry.getGenericMethod());
        if (!definitionEnv.isPresent()) {
            context.warn(String.format("Cannot resolve namespace environment from generic function '%s'", entry.getGenericMethod()));
            return;
        }
        if (!definitionEnv.get().hasVariable(S3.METHODS_TABLE)) {
            definitionEnv.get().setVariableUnsafe(S3.METHODS_TABLE, (SEXP)Environment.createChildEnvironment(context.getBaseEnvironment()).build());
        }
        Environment methodsTable = (Environment)definitionEnv.get().getVariableUnsafe(S3.METHODS_TABLE);
        methodsTable.setVariableUnsafe(entry.getGenericMethod() + "." + entry.getClassName(), (SEXP)method);
    }

    private Function resolveFunction(Context context, String functionName) {
        SEXP methodExp = this.namespaceEnvironment.getVariableUnsafe(functionName).force(context);
        if (methodExp == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Missing export: " + functionName + " not found in " + this.getName(), new Object[0]);
        }
        if (!(methodExp instanceof Function)) {
            throw new EvalException(functionName + ": expected function but was " + methodExp.getTypeName(), new Object[0]);
        }
        return (Function)methodExp;
    }

    private Optional<Environment> resolveGenericFunctionNamespace(Context context, String genericName) {
        if (S3.GROUPS.contains(genericName)) {
            return Optional.of(this.baseNamespaceEnvironment);
        }
        Function genericFunction = this.namespaceEnvironment.findFunction(context, Symbol.get(genericName));
        if (genericFunction == null) {
            return Optional.absent();
        }
        if (genericFunction instanceof Closure) {
            return Optional.of(((Closure)genericFunction).getEnclosingEnvironment());
        }
        if (genericFunction instanceof PrimitiveFunction) {
            return Optional.of(this.baseNamespaceEnvironment);
        }
        throw new EvalException("Cannot resolve namespace environment from generic function '%s' of type '%s'", genericName, genericFunction.getTypeName());
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

