/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.ListSubsetting;
import org.renjin.primitives.subset.LogicalPredicate;
import org.renjin.primitives.subset.LogicalSubscript;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.VectorIndexSelection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.util.NamesBuilder;

class LogicalSelection
implements SelectionStrategy {
    private final LogicalVector mask;

    public LogicalSelection(LogicalVector mask) {
        this.mask = mask;
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        LogicalSubscript subscript = new LogicalSubscript(this.mask, source.length());
        return VectorIndexSelection.buildSelection(source, subscript, drop2);
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        source = (AtomicVector)context.materialize(source);
        replacements = context.materialize(replacements);
        if (this.mask.length() <= source.length()) {
            return this.buildMaskedReplacement(source, replacements);
        }
        return this.buildExtendedReplacement(source, replacements);
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector source, Vector replacement) {
        if (replacement == Null.INSTANCE) {
            if (this.mask.length() == 0) {
                return source;
            }
            return ListSubsetting.removeListElements(source, new LogicalPredicate(this.mask));
        }
        if (this.mask.length() <= source.length()) {
            return (ListVector)this.buildMaskedReplacement(source, replacement);
        }
        return (ListVector)this.buildExtendedReplacement(source, replacement);
    }

    private Vector buildExtendedReplacement(Vector source, Vector replacements) {
        assert (source.length() < this.mask.length());
        int resultLength = this.mask.length();
        int sourceLength = source.length();
        Vector.Builder result = Vector.Type.widest(source, (SEXP)replacements).newBuilderWithInitialCapacity(resultLength);
        AtomicVector sourceNames = source.getNames();
        NamesBuilder resultNames = null;
        if (sourceNames != Null.INSTANCE) {
            resultNames = NamesBuilder.withInitialCapacity(resultLength);
        }
        int replacementIndex = 0;
        for (int i = 0; i < resultLength; ++i) {
            int maskValue = this.mask.getElementAsRawLogical(i);
            if (maskValue == 0) {
                if (i < sourceLength) {
                    result.addFrom(source, i);
                    if (resultNames == null) continue;
                    resultNames.add(sourceNames.getElementAsString(i));
                    continue;
                }
                result.addNA();
                if (resultNames == null) continue;
                resultNames.add("");
                continue;
            }
            if (IntVector.isNA(maskValue)) {
                result.setNA(i);
                if (resultNames == null) continue;
                resultNames.add("");
                continue;
            }
            result.setFrom(i, replacements, replacementIndex);
            if (resultNames != null) {
                if (i < sourceLength) {
                    resultNames.add(sourceNames.getElementAsString(i));
                } else {
                    resultNames.add("");
                }
            }
            if (++replacementIndex < replacements.length()) continue;
            replacementIndex = 0;
        }
        if (resultNames != null) {
            result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        }
        return result.build();
    }

    private Vector buildMaskedReplacement(Vector source, Vector replacements) {
        Vector.Builder builder = source.newCopyBuilder(replacements.getVectorType());
        int maskIndex = 0;
        int replacementIndex = 0;
        int sourceLength = source.length();
        if (this.mask.length() > 0) {
            for (int resultIndex = 0; resultIndex < sourceLength; ++resultIndex) {
                int maskValue;
                if ((maskValue = this.mask.getElementAsRawLogical(maskIndex++)) != 1) continue;
                if (replacements.length() == 0) {
                    throw new EvalException("replacement has zero length", new Object[0]);
                }
                builder.setFrom(resultIndex, replacements, replacementIndex++);
                if (replacementIndex < replacements.length()) continue;
                replacementIndex = 0;
                if (maskIndex < this.mask.length()) continue;
                maskIndex = 0;
            }
        }
        return builder.build();
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        throw new UnsupportedOperationException("[[ operator never uses logical subscripts");
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        throw new UnsupportedOperationException("[[ operator never uses logical subscrpts");
    }

    @Override
    public Vector replaceSingleElement(Context context, AtomicVector source, Vector replacement) {
        throw new UnsupportedOperationException("[[ operator never uses logical subscrpts");
    }

    @Override
    public ListVector replaceSingleListElement(ListVector list2, SEXP replacement) {
        throw new UnsupportedOperationException("[[ operator never uses logical subscrpts");
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node list2, SEXP replacement) {
        throw new UnsupportedOperationException("[[ operator never uses logical subscrpts");
    }
}

