/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexPredicate;
import org.renjin.primitives.subset.Subscript;

public class MissingSubscript
implements Subscript {
    private int sourceLength;

    public MissingSubscript(int sourceLength) {
        this.sourceLength = sourceLength;
    }

    @Override
    public int computeUniqueIndex() {
        throw new EvalException("[[ ]] with missing subscripts", new Object[0]);
    }

    @Override
    public IndexIterator computeIndexes() {
        return new IndexIterator(){
            private int i = 0;

            @Override
            public int next() {
                if (this.i >= MissingSubscript.this.sourceLength) {
                    return -1;
                }
                return this.i++;
            }

            @Override
            public void restart() {
                this.i = 0;
            }
        };
    }

    @Override
    public IndexPredicate computeIndexPredicate() {
        return new IndexPredicate(){

            @Override
            public boolean apply(int index) {
                return true;
            }
        };
    }

    @Override
    public int computeCount() {
        return this.sourceLength;
    }
}

