/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.summary;

import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Vector;

public abstract class DeferredSummary
extends DoubleVector
implements MemoizedComputation {
    protected final Vector vector;
    private double result;
    private boolean calculated = false;

    public DeferredSummary(Vector vector2, AttributeMap attributes2) {
        super(attributes2);
        this.vector = vector2;
    }

    @Override
    public final Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    @Override
    public final double getElementAsDouble(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("index: " + index);
        }
        if (!this.calculated) {
            this.result = this.calculate();
            this.calculated = true;
        }
        return this.result;
    }

    protected abstract double calculate();

    @Override
    public final int length() {
        return 1;
    }

    @Override
    public final boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public final boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public boolean isDeferred() {
        return !this.isCalculated();
    }

    @Override
    public final Vector forceResult() {
        if (!this.calculated) {
            this.result = this.calculate();
            this.calculated = true;
        }
        return new DoubleArrayVector(this.result, this.getAttributes());
    }

    @Override
    public final void setResult(Vector result) {
        this.result = result.getElementAsDouble(0);
        this.calculated = true;
    }

    @Override
    public String toString() {
        if (this.calculated) {
            return Double.toString(this.result);
        }
        return "<deferred " + this.getComputationName() + ">";
    }
}

