/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

abstract class AbstractVector
extends AbstractSEXP
implements Vector {
    protected AbstractVector(SEXP tag, AttributeMap attributes2) {
        super(attributes2);
    }

    protected AbstractVector(AttributeMap attributes2) {
        super(attributes2);
    }

    protected AbstractVector() {
    }

    @Override
    public boolean isElementTrue(int index) {
        return this.getElementAsRawLogical(index) == 1;
    }

    @Override
    public boolean isElementNaN(int index) {
        return this.isElementNA(index);
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public byte getElementAsByte(int index) {
        int value = this.getElementAsInt(index);
        if (value < 0 || value > 255) {
            return 0;
        }
        return (byte)value;
    }

    @Override
    public double getElementAsComplexIm(int index) {
        return 0.0;
    }

    @Override
    public Vector.Builder newCopyBuilder(Vector.Type replacementType) {
        if (this.getVectorType().isWiderThanOrEqualTo(replacementType)) {
            return this.newCopyBuilder();
        }
        Vector.Builder result = replacementType.newBuilderWithInitialSize(this.length());
        result.copyAttributesFrom(this);
        for (int i = 0; i != this.length(); ++i) {
            result.setFrom(i, this, i);
        }
        return result;
    }

    @Override
    public int getComputationDepth() {
        return 0;
    }

    @Override
    public void copyTo(double[] array2, int offset, int length2) {
        for (int i = 0; i < length2; ++i) {
            array2[offset + i] = this.getElementAsDouble(i);
        }
    }

    static abstract class AbstractBuilder<S extends SEXP>
    implements Vector.Builder<S> {
        private final AttributeMap.Builder attributes = AttributeMap.builder();

        AbstractBuilder() {
        }

        @Override
        public Vector.Builder setAttribute(String name, SEXP value) {
            return this.setAttribute(Symbol.get(name), value);
        }

        @Override
        public Vector.Builder setAttribute(Symbol name, SEXP value) {
            if (value != Null.INSTANCE) {
                this.attributes.set(name, value);
            }
            return this;
        }

        @Override
        public Vector.Builder removeAttribute(Symbol name) {
            this.attributes.remove(name);
            return this;
        }

        @Override
        public Vector.Builder setDim(int row2, int col2) {
            this.attributes.setDim(row2, col2);
            return this;
        }

        @Override
        public SEXP getAttribute(Symbol name) {
            return this.attributes.get(name);
        }

        @Override
        public Vector.Builder copyAttributesFrom(SEXP exp2) {
            this.attributes.addAllFrom(exp2.getAttributes());
            return this;
        }

        @Override
        public Vector.Builder combineAttributesFrom(SEXP vector2) {
            AttributeMap attributes2 = vector2.getAttributes();
            if (attributes2 != AttributeMap.EMPTY) {
                this.attributes.combineFrom(attributes2);
            }
            return this;
        }

        @Override
        public Vector.Builder combineStructuralAttributesFrom(SEXP vector2) {
            AttributeMap vectorAttributes = vector2.getAttributes();
            if (vectorAttributes != AttributeMap.EMPTY) {
                this.attributes.combineStructuralFrom(vectorAttributes);
            }
            return this;
        }

        @Override
        public Vector.Builder addNA() {
            return this.setNA(this.length());
        }

        @Override
        public Vector.Builder addFrom(S source, int sourceIndex) {
            return this.setFrom(this.length(), source, sourceIndex);
        }

        protected AttributeMap buildAttributes() {
            return this.attributes.build();
        }
    }
}

