/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.repackaged.guava.base.Objects;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;

public class Closure
extends AbstractSEXP
implements Function {
    public static final String TYPE_NAME = "closure";
    private Environment enclosingEnvironment;
    private SEXP body;
    private PairList formals;
    private int invocationCount = 0;
    private boolean compilationFailed = false;

    public Closure(Environment enclosingEnvironment, PairList formals2, SEXP body2, AttributeMap attributes2) {
        super(attributes2);
        assert (!(formals2 instanceof FunctionCall));
        this.enclosingEnvironment = enclosingEnvironment;
        this.body = body2;
        this.formals = formals2;
    }

    public Closure(Environment environment2, PairList formals2, SEXP body2) {
        this(environment2, formals2, body2, AttributeMap.EMPTY);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap newAttributes) {
        return new Closure(this.enclosingEnvironment, this.formals, this.body, newAttributes);
    }

    @Override
    public String getImplicitClass() {
        return "function";
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        ClosureDispatcher dispatcher = new ClosureDispatcher(context, rho, call2);
        return dispatcher.applyClosure(this, args2);
    }

    public SEXP doApply(Context functionContext) {
        ++this.invocationCount;
        return functionContext.evaluate(this.body);
    }

    public Environment getEnclosingEnvironment() {
        return this.enclosingEnvironment;
    }

    public Closure setEnclosingEnvironment(Environment env2) {
        return new Closure(env2, this.formals, this.body, this.getAttributes());
    }

    public SEXP getBody() {
        return this.body;
    }

    public PairList getFormals() {
        return this.formals;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("function(");
        if (this.getFormals() instanceof PairList.Node) {
            ((PairList.Node)this.getFormals()).appendValuesTo(sb);
        }
        return sb.append(")").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.enclosingEnvironment == null ? 0 : this.enclosingEnvironment.hashCode());
        result = 31 * result + (this.formals == null ? 0 : this.formals.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Closure)) {
            return false;
        }
        Closure other = (Closure)obj;
        if (!Objects.equal(this.body, other.body)) {
            return false;
        }
        if (!Objects.equal(this.enclosingEnvironment, other.enclosingEnvironment)) {
            return false;
        }
        return Objects.equal(this.formals, other.formals);
    }
}

