/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

public enum Logical {
    TRUE(1),
    FALSE(0),
    NA(Integer.MIN_VALUE);

    private int internalValue;

    private Logical(int internalValue) {
        this.internalValue = internalValue;
    }

    public static Logical valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Logical valueOf(int i) {
        if (i == 1) {
            return TRUE;
        }
        if (i == 0) {
            return FALSE;
        }
        return NA;
    }

    public static String toString(int value) {
        if (value == 1) {
            return "TRUE";
        }
        if (value == 0) {
            return "FALSE";
        }
        return "NA";
    }

    public boolean toBooleanStrict() {
        return this.getInternalValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public int getInternalValue() {
        return this.internalValue;
    }
}

