/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.invoke.annotations.Operand;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceMatrix
extends DoubleVector
implements DeferredComputation {
    @Operand
    private Vector vector;
    private int size;
    private int length;

    public Euclidean1dDistanceMatrix(Vector vector2, AttributeMap attributeMap) {
        super(attributeMap);
        this.vector = vector2;
        this.size = vector2.length();
        this.length = this.size * this.size;
    }

    public Euclidean1dDistanceMatrix(Vector vector2) {
        this(vector2, AttributeMap.dim(vector2.length(), vector2.length()));
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributeMap) {
        return new Euclidean1dDistanceMatrix(this.vector, attributeMap);
    }

    @Override
    public String getComputationName() {
        return "dist";
    }

    @Override
    public double getElementAsDouble(int n) {
        int n2 = this.vector.length();
        if ((n %= n2) == (n2 = n / n2)) {
            return 0.0;
        }
        return Math.abs(this.getOperandElementAsDouble(n) - this.getOperandElementAsDouble(n2));
    }

    private double getOperandElementAsDouble(int n) {
        return this.vector.getElementAsDouble(n);
    }

    private int getOperandLength() {
        return this.vector.length();
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public int length() {
        return this.getOperandLength() * this.getOperandLength();
    }

    public static double test(int n, int n2) {
        return Math.sqrt(n % n2);
    }
}

