/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.renjin.primitives.matrix.IntMatrixBuilder;
import org.renjin.repackaged.guava.base.Functions;
import org.renjin.repackaged.guava.collect.Collections2;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.stats.internals.models.Term;

public class Formula {
    private FunctionCall expandedFormula;
    private SEXP response;
    private List<Term> terms = Lists.newArrayList();
    private int intercept = 1;

    public Formula(FunctionCall expandedFormula, int intercept, Iterable<Term> terms2) {
        this.expandedFormula = expandedFormula;
        this.response = expandedFormula.getArguments().length() == 2 ? expandedFormula.getArgument(0) : null;
        this.terms = Lists.newArrayList(terms2);
        this.intercept = intercept;
    }

    public FunctionCall getExpandedFormula() {
        return this.expandedFormula;
    }

    public SEXP getResponse() {
        return this.response;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public int getIntercept() {
        return this.intercept;
    }

    public List<SEXP> uniqueVariables() {
        ArrayList<SEXP> variables = Lists.newArrayList();
        if (this.response != null) {
            variables.add(this.response);
        }
        for (Term term : this.terms) {
            for (SEXP expr : term) {
                if (variables.contains(expr)) continue;
                variables.add(expr);
            }
        }
        return variables;
    }

    public FunctionCall buildVariablesAttribute() {
        PairList.Builder args2 = new PairList.Builder();
        for (SEXP variable : this.uniqueVariables()) {
            args2.add(variable);
        }
        return new FunctionCall(Symbol.get("list"), args2.build());
    }

    public SEXP buildFactorsMatrix() {
        if (this.terms.size() == 0) {
            return new IntArrayVector(new int[0]);
        }
        List<SEXP> variables = this.uniqueVariables();
        IntMatrixBuilder matrix2 = new IntMatrixBuilder(variables.size(), this.terms.size());
        matrix2.setRowNames((Collection)Collections2.transform(variables, Functions.toStringFunction()));
        matrix2.setColNames(this.buildTermLabels());
        for (int row2 = 0; row2 != variables.size(); ++row2) {
            for (int col2 = 0; col2 != this.terms.size(); ++col2) {
                if (this.terms.get(col2).getExpressions().contains(variables.get(row2))) {
                    matrix2.set(row2, col2, 1);
                    continue;
                }
                matrix2.set(row2, col2, 0);
            }
        }
        return matrix2.build();
    }

    public StringVector buildTermLabels() {
        StringVector.Builder labels = new StringVector.Builder();
        for (Term term : this.terms) {
            labels.add(term.getLabel());
        }
        return labels.build();
    }

    public SEXP buildInteractionOrderAttribute() {
        IntArrayVector.Builder order2 = new IntArrayVector.Builder();
        for (Term term : this.terms) {
            order2.add(term.getOrder());
        }
        return order2.build();
    }

    public IntVector buildInterceptAttribute() {
        return new IntArrayVector(this.intercept);
    }

    public IntVector buildResponseAttribute() {
        return new IntArrayVector(this.response == null ? 0 : 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.intercept;
        result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
        result = 31 * result + (this.terms == null ? 0 : this.terms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Formula other = (Formula)obj;
        if (this.intercept != other.intercept) {
            return false;
        }
        if (this.response != other.response) {
            return false;
        }
        return this.terms.equals(other.terms);
    }

    public String toString() {
        return this.response + " ~ " + this.intercept + " + " + this.terms.toString();
    }
}

