/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.stats.internals.optimize.UnivariateRealClosure;

public class Roots {
    @Internal
    public static DoubleVector zeroin2(@Current Context context, @Current Environment rho, Function fn, double lower, double upper, double fLower, double fUpper, double tol, int maximumIterations) {
        int iterations;
        double root;
        BrentSolver solver = new BrentSolver(maximumIterations, tol);
        double estimatedPrecision = 2.220446E-16;
        try {
            root = solver.solve(maximumIterations, new UnivariateRealClosure(context, rho, fn), lower, upper);
            iterations = 1;
        }
        catch (MaxIterationsExceededException e) {
            root = DoubleVector.NA;
            iterations = -1;
        }
        catch (FunctionEvaluationException e) {
            throw new EvalException(e);
        }
        return new DoubleArrayVector(root, iterations, estimatedPrecision);
    }
}

