/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.LayeredFileNameParser;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider
implements FileProvider {
    public AbstractLayeredFileProvider() {
        this.setFileNameParser(LayeredFileNameParser.getInstance());
    }

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        FileName fileName = name.getOuterName();
        FileObject file2 = this.getContext().resolveFile(baseFile, fileName.getURI(), properties);
        FileObject rootFile = this.createFileSystem(name.getScheme(), file2, properties);
        return rootFile.resolveFile(name.getPath());
    }

    public synchronized FileObject createFileSystem(String scheme, FileObject file2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = file2.getName();
        FileSystem fs = this.findFileSystem(rootName, null);
        if (fs == null) {
            fs = this.doCreateFileSystem(scheme, file2, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3) throws FileSystemException;
}

