/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;

public class ArgumentBounds {
    private String name;
    private ValueBounds bounds;

    public ArgumentBounds(String name, ValueBounds bounds) {
        this.name = name;
        this.bounds = bounds;
    }

    public ArgumentBounds(ValueBounds valueBounds) {
        this.name = null;
        this.bounds = valueBounds;
    }

    public String getName() {
        return this.name;
    }

    public ValueBounds getBounds() {
        return this.bounds;
    }

    public static List<ArgumentBounds> create(List<IRArgument> arguments, Map<Expression, ValueBounds> typeMap) {
        ArrayList<ArgumentBounds> result = new ArrayList<ArgumentBounds>();
        for (int i = 0; i < arguments.size(); ++i) {
            IRArgument symbolArgument = arguments.get(i);
            Expression argumentExpr = symbolArgument.getExpression();
            ValueBounds argumentBounds = argumentExpr instanceof Constant ? argumentExpr.getValueBounds() : typeMap.get(argumentExpr);
            assert (argumentBounds != null) : "No argument bounds for " + symbolArgument.getName();
            result.add(new ArgumentBounds(symbolArgument.getName(), argumentBounds));
        }
        return result;
    }

    public static List<ValueBounds> withoutNames(List<ArgumentBounds> argumentBounds) {
        ArrayList<ValueBounds> values = new ArrayList<ValueBounds>();
        for (ArgumentBounds argumentBound : argumentBounds) {
            values.add(argumentBound.getBounds());
        }
        return values;
    }
}

