/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.ConstantBytecode;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class ConstantCall
implements Specialization {
    private Object constantValue;
    private Type type;
    private ValueBounds valueBounds;

    public ConstantCall(Object constantValue) {
        this.constantValue = constantValue;
        if (constantValue instanceof Integer) {
            this.type = Type.INT_TYPE;
            this.valueBounds = ValueBounds.of(IntVector.valueOf((Integer)constantValue));
        } else if (constantValue instanceof Double) {
            this.type = Type.DOUBLE_TYPE;
            this.valueBounds = ValueBounds.of(DoubleVector.valueOf((Double)constantValue));
        } else if (constantValue instanceof Boolean) {
            this.type = Type.BOOLEAN_TYPE;
            this.valueBounds = ValueBounds.of(LogicalVector.valueOf((Boolean)constantValue));
        } else if (constantValue instanceof String) {
            this.type = Type.getType(String.class);
            this.valueBounds = ValueBounds.of(StringVector.valueOf((String)constantValue));
        } else if (constantValue instanceof SEXP) {
            this.type = Type.getType(constantValue.getClass());
            this.valueBounds = ValueBounds.of((SEXP)constantValue);
        } else {
            throw new UnsupportedOperationException("constantValue: " + constantValue);
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.valueBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        if (this.constantValue instanceof Integer) {
            mv.iconst((Integer)this.constantValue);
        } else if (this.constantValue instanceof Double) {
            mv.dconst((Double)this.constantValue);
        } else if (this.constantValue instanceof Boolean) {
            mv.iconst(this.constantValue == Boolean.TRUE ? 1 : 0);
        } else if (this.constantValue instanceof SEXP) {
            ConstantBytecode.pushConstant(mv, (SEXP)this.constantValue);
        } else {
            throw new UnsupportedOperationException("constantValue: " + this.constantValue.getClass());
        }
    }

    @Override
    public boolean isPure() {
        return true;
    }

    public static ConstantCall evaluate(JvmMethod method, List<ValueBounds> arguments) {
        Object constantValue;
        ListVector.Builder varArgs = null;
        HashMap<String, Boolean> namedFlags = null;
        if (method.acceptsArgumentList()) {
            namedFlags = new HashMap<String, Boolean>();
            varArgs = ListVector.newBuilder();
            for (JvmMethod.Argument formal : method.getFormals()) {
                if (!formal.isNamedFlag()) continue;
                namedFlags.put(formal.getName(), formal.getDefaultValue());
            }
            for (ValueBounds argument : arguments) {
                varArgs.add(argument.getConstantValue());
            }
        }
        List<JvmMethod.Argument> formals2 = method.getAllArguments();
        Object[] args2 = new Object[formals2.size()];
        Iterator<ValueBounds> it = arguments.iterator();
        int argI = 0;
        for (JvmMethod.Argument formal : formals2) {
            if (formal.isVarArg()) {
                args2[argI++] = varArgs.build();
                continue;
            }
            if (formal.isNamedFlag()) {
                args2[argI++] = namedFlags.get(formal.getName());
                continue;
            }
            if (formal.isContextual()) {
                throw new UnsupportedOperationException("in " + method + ", " + "formal: " + formal);
            }
            ValueBounds argument = it.next();
            Class formalType = formal.getClazz();
            args2[argI++] = ConstantCall.convert(argument.getConstantValue(), formalType);
        }
        try {
            constantValue = method.getMethod().invoke(null, args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ConstantCall(constantValue);
    }

    public static Object convert(SEXP constantValue, Class formalType) {
        return Converters.get(formalType).convertToJava(constantValue);
    }

    private static void evaluateVarArgs(JvmMethod method, List<ValueBounds> arguments) {
    }
}

