/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.GetAtomicElement;
import org.renjin.compiler.builtins.GetListElement;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;

public class SingleSubsetSpecializer
implements BuiltinSpecializer {
    @Override
    public String getName() {
        return "[[";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        if (arguments.size() == 2) {
            ValueBounds source = arguments.get(0).getBounds();
            ValueBounds index = arguments.get(1).getBounds();
            if (TypeSet.isDefinitelyNumeric(index) && index.isLengthConstant() && index.getLength() == 1) {
                if (source.getTypeSet() == 2) {
                    return new GetListElement(source, index);
                }
                if (TypeSet.isDefinitelyAtomic(source.getTypeSet())) {
                    return new GetAtomicElement(source, index);
                }
            }
            throw new UnsupportedOperationException("TODO");
        }
        return UnspecializedCall.INSTANCE;
    }
}

